/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.nsapp.common.core.util;

import com.geoway.nsapp.common.core.constants.Constants;
import com.geoway.nsapp.common.core.enums.ShapeType;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import org.apache.commons.lang3.StringUtils;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.springframework.util.Assert;

public class GeometryUtils {
    private static final String projectiveCoordinateSystems = "PROJCS[\"CGCS2000_3_Degree_GK_Zone_%d\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",%d500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",%d],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]";
    private static final String cgcsGeo = "GEOGCS[\"GCS_CGCS_2000\",DATUM[\"D_GCS_CGCS_2000\",SPHEROID[\"D_China_2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]]";
    public static final Double DEFAULT_BUFFER = 2.697963123853744E-5;

    public static Geometry wktToGeometry(String wkt, Integer spatialReferenceSystemId) throws ParseException {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)wkt), (String)"\u53c2\u6570wkt\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String[] sections = wkt.split(";");
        String coordinates = sections.length > 1 ? sections[sections.length - 1] : wkt;
        WKTReader reader = new WKTReader();
        Geometry geometry = reader.read(coordinates);
        geometry.setSRID((spatialReferenceSystemId == null ? Constants.GEOMETRY_SRID : spatialReferenceSystemId).intValue());
        return geometry;
    }

    public static String geometryToWkt(Geometry geometry) {
        WKTWriter writer = new WKTWriter();
        return writer.write(geometry);
    }

    public static Geometry bufferGeometry(Geometry geometry, int buffer) throws Exception {
        if (geometry == null || geometry.getCentroid() == null) {
            throw new IllegalArgumentException("geometry\u5bf9\u8c61\u6216\u4e2d\u5fc3\u70b9\u4e3a\u7a7a");
        }
        CoordinateReferenceSystem destCRS = GeometryUtils.findTargetProjectiveCRS(geometry.getCentroid().getX());
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)destCRS, (boolean)true);
        Geometry newGeo = JTS.transform((Geometry)geometry, (MathTransform)transform);
        newGeo = newGeo.buffer((double)buffer);
        transform = CRS.findMathTransform((CoordinateReferenceSystem)destCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
        newGeo = JTS.transform((Geometry)newGeo, (MathTransform)transform);
        return newGeo;
    }

    public static int getProjectiveNoByLongitude(Double longitude) {
        if (longitude == null) {
            throw new IllegalArgumentException("\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return (int)((longitude - 1.5) / 3.0) + 1;
    }

    public static CoordinateReferenceSystem findTargetProjectiveCRS(Double longitude) throws FactoryException {
        int projectionNo = GeometryUtils.getProjectiveNoByLongitude(longitude);
        if (projectionNo > 60) {
            return null;
        }
        String wkt = String.format(projectiveCoordinateSystems, projectionNo, projectionNo, projectionNo * 3);
        return CRS.parseWKT((String)wkt);
    }

    public static ShapeType getShapeTypeByWkt(String wkt) {
        if (StringUtils.isBlank((CharSequence)wkt)) {
            return null;
        }
        String type = wkt.substring(0, wkt.indexOf("(")).trim();
        switch (type.toUpperCase()) {
            case "POINT": {
                return ShapeType.POINT;
            }
            case "LINESTRING": {
                return ShapeType.LINE_STRING;
            }
            case "MULTILINESTRING": {
                return ShapeType.MULTI_LINE_STRING;
            }
            case "POLYGON": {
                return ShapeType.POLYGON;
            }
            case "MULTIPOLYGON": {
                return ShapeType.MULTI_POLYGON;
            }
        }
        return null;
    }

    public static Geometry transform(Geometry geometry) throws FactoryException, TransformException {
        if (geometry == null || geometry.getCentroid() == null) {
            throw new IllegalArgumentException("geometry\u5bf9\u8c61\u6216\u4e2d\u5fc3\u70b9\u4e3a\u7a7a");
        }
        CoordinateReferenceSystem destCRS = GeometryUtils.findTargetProjectiveCRS(geometry.getCentroid().getX());
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)destCRS, (boolean)true);
        return JTS.transform((Geometry)geometry, (MathTransform)transform);
    }

    public static Double calcOverlayRate(Geometry geometry1, Geometry geometry2) {
        Geometry intersection = geometry1.intersection(geometry2);
        if (intersection != null) {
            return intersection.getArea() / geometry1.getArea();
        }
        return null;
    }

    public static CoordinateReferenceSystem getCGCS200CRS() throws FactoryException {
        return CRS.parseWKT((String)cgcsGeo);
    }
}

