/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.nsapp.common.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public class ListUtil {
    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static <T> List<List<T>> split(List<T> list, int batchSize) {
        ArrayList<List<T>> batches = new ArrayList<List<T>>();
        for (int i = 0; i < list.size(); i += batchSize) {
            batches.add(new ArrayList<T>(list.subList(i, Math.min(i + batchSize, list.size()))));
        }
        return batches;
    }
}

