/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.nsapp.common.core.util;

import com.geoway.nsapp.common.core.util.SSLUtils;
import java.io.IOException;
import java.security.KeyManagementException;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpUtils {
    private static OkHttpClient client = null;

    public static String get(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        if (params != null) {
            params.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
        }
        Request.Builder requestBuilder = new Request.Builder().url(urlBuilder.build()).get();
        OkHttpUtils.addHeaders(requestBuilder, headers);
        try (Response response = client.newCall(requestBuilder.build()).execute();){
            String string = response.body().string();
            return string;
        }
    }

    public static String postForm(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        FormBody.Builder formBuilder = new FormBody.Builder();
        if (params != null) {
            params.forEach((arg_0, arg_1) -> ((FormBody.Builder)formBuilder).add(arg_0, arg_1));
        }
        Request.Builder requestBuilder = new Request.Builder().url(url).post((RequestBody)formBuilder.build());
        OkHttpUtils.addHeaders(requestBuilder, headers);
        try (Response response = client.newCall(requestBuilder.build()).execute();){
            String string = response.body().string();
            return string;
        }
    }

    public static String postBody(String url, String jsonBody, Map<String, String> headers) throws IOException {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonBody);
        Request.Builder requestBuilder = new Request.Builder().url(url).post(body);
        OkHttpUtils.addHeaders(requestBuilder, headers);
        try (Response response = client.newCall(requestBuilder.build()).execute();){
            String string = response.body().string();
            return string;
        }
    }

    private static void addHeaders(Request.Builder builder, Map<String, String> headers) {
        if (headers != null) {
            Headers.Builder headerBuilder = new Headers.Builder();
            headers.forEach((arg_0, arg_1) -> ((Headers.Builder)headerBuilder).add(arg_0, arg_1));
            builder.headers(headerBuilder.build());
        }
    }

    static {
        try {
            client = SSLUtils.getUnsafeOkHttpClient();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }
}

