/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.nsapp.common.core.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.nsapp.common.core.enums.PdfCellType;
import com.geoway.nsapp.common.core.enums.PdfFont;
import com.geoway.nsapp.common.core.vo.PdfCellImageInfo;
import com.geoway.nsapp.common.core.vo.PdfCellInfo;
import com.geoway.nsapp.common.core.vo.PdfElementInfo;
import com.geoway.nsapp.common.core.vo.PdfImageInfo;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PdfUtil {
    private static final Logger log = LogManager.getLogger(PdfUtil.class);

    public static void buildPdf(String path, Map<String, Object> data, boolean showPageNumber) throws IOException, DocumentException {
        Document document = new Document();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]));
        if (showPageNumber) {
            PdfUtil.addPageFooter(writer);
        }
        document.open();
        PdfUtil.fillDocument(document, data);
        document.close();
    }

    private static void fillDocument(Document document, Map<String, Object> data) throws DocumentException, IOException {
        Rectangle pageSize = document.getPageSize();
        float firstPageMarginTop = 64.0f;
        float pageMarginTop = 109.0f;
        float pageHeight = pageSize.getHeight() - 109.0f;
        Font fontTitle = PdfUtil.createFont(PdfFont.SIM_HEI.value, 18, true, BaseColor.BLACK);
        document.setMargins(0.0f, 0.0f, 64.0f, 0.0f);
        document.newPage();
        float currentHeight = 0.0f;
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            Object value = entry.getValue();
            if (entry.getKey().equals("title")) {
                Paragraph title = new Paragraph(value == null ? " " : value.toString(), fontTitle);
                title.setAlignment(1);
                title.setSpacingAfter(27.0f);
                document.add((Element)title);
                continue;
            }
            if (entry.getValue() instanceof PdfImageInfo) {
                PdfImageInfo pdfImageInfo = (PdfImageInfo)value;
                Image image = PdfUtil.createImage(pdfImageInfo);
                if (image == null) continue;
                document.add((Element)image);
                continue;
            }
            if (!entry.getKey().equals("table")) continue;
            JSONArray rows = JSONObject.parseArray((String)value.toString());
            for (Object row : rows) {
                JSONArray cells = JSONObject.parseArray((String)row.toString());
                PdfPTable table = new PdfPTable(cells.size());
                table.setSplitLate(false);
                for (int i = 0; i < cells.size(); ++i) {
                    Object cellObject = cells.get(i);
                    PdfElementInfo elementInfo = (PdfElementInfo)cellObject;
                    if (i == 0 && (currentHeight += (float)(elementInfo.getHeight() == 0 ? 40 : elementInfo.getHeight())) > pageHeight) {
                        document.setMargins(0.0f, 0.0f, 64.0f, 0.0f);
                        document.newPage();
                        Image stamp = PdfUtil.getStampImage(data);
                        if (stamp != null) {
                            document.add((Element)stamp);
                        }
                        currentHeight = 0.0f;
                    }
                    if (cellObject instanceof PdfCellInfo) {
                        PdfPCell pdfCell = PdfUtil.createCell((PdfCellInfo)cellObject);
                        table.addCell(pdfCell);
                        continue;
                    }
                    if (!(cellObject instanceof PdfCellImageInfo)) continue;
                    PdfPTable imageTableCell = PdfUtil.createImageTable((PdfCellImageInfo)cellObject);
                    table.addCell(new PdfPCell(imageTableCell));
                }
                document.add((Element)table);
            }
        }
    }

    private static Image getStampImage(Map<String, Object> data) throws IOException, BadElementException {
        Object value = data.get("stamp");
        if (!(value instanceof PdfImageInfo)) {
            return null;
        }
        PdfImageInfo pdfImageInfo = (PdfImageInfo)value;
        return PdfUtil.createImage(pdfImageInfo);
    }

    public static BaseColor getColor(String color) {
        if (StringUtils.isBlank((CharSequence)color)) {
            return null;
        }
        if (color.startsWith("#")) {
            color = color.substring(1);
        }
        return new BaseColor(Integer.parseInt(color.substring(0, 2), 16), Integer.parseInt(color.substring(2, 4), 16), Integer.parseInt(color.substring(4, 6), 16));
    }

    private static PdfPCell createCell(PdfCellInfo cellInfo) throws IOException, DocumentException {
        PdfFont pdfFont = PdfFont.getByCode(cellInfo.getFont());
        Font font = PdfUtil.createFont(pdfFont == null ? null : pdfFont.value, cellInfo.getFontSize(), BooleanUtils.isTrue((Boolean)cellInfo.getBold()), PdfUtil.getColor(cellInfo.getColor()));
        PdfPCell cell = new PdfPCell(new Phrase(cellInfo.getText(), font));
        cell.setHorizontalAlignment(cellInfo.getAlign() != null ? cellInfo.getAlign() : 1);
        cell.setVerticalAlignment(5);
        if (BooleanUtils.isFalse((Boolean)cellInfo.getBorder())) {
            cell.setBorder(0);
        }
        if (StringUtils.isNotBlank((CharSequence)cellInfo.getBackgroundColor())) {
            cell.setBackgroundColor(PdfUtil.getColor(cellInfo.getBackgroundColor()));
        }
        cell.setMinimumHeight(cellInfo.getHeight() == null || cellInfo.getHeight() == 0 ? 40.0f : (float)cellInfo.getHeight().intValue());
        return cell;
    }

    private static Font createFont(String fontName, int fontSize, boolean bold, BaseColor baseColor) throws IOException, DocumentException {
        int fontWeight;
        String fontDir = "/../../fonts";
        BaseFont baseFont = BaseFont.createFont((String)(fontDir + "/" + (StringUtils.isBlank((CharSequence)fontName) ? PdfFont.ST_SONG.value : fontName)), (String)"Identity-H", (boolean)false);
        int n = fontWeight = bold ? 1 : 0;
        if (baseColor != null) {
            return new Font(baseFont, (float)fontSize, fontWeight, baseColor);
        }
        return new Font(baseFont, (float)fontSize, fontWeight, BaseColor.BLACK);
    }

    private static void addPageFooter(PdfWriter writer) {
        PdfPageEventHelper event = new PdfPageEventHelper(){

            public void onEndPage(PdfWriter writer, Document document) {
                PdfContentByte pdfContentByte = writer.getDirectContent();
                pdfContentByte.saveState();
                pdfContentByte.beginText();
                BaseFont baseFont = null;
                try {
                    baseFont = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
                }
                catch (Exception exception) {
                    log.error((Object)exception);
                }
                pdfContentByte.setFontAndSize(baseFont, 10.0f);
                float y = document.bottom(10.0f);
                pdfContentByte.showTextAligned(1, String.valueOf(writer.getPageNumber()), (document.right() + document.left()) / 2.0f, y, 0.0f);
                pdfContentByte.endText();
                pdfContentByte.restoreState();
            }
        };
        writer.setPageEvent((PdfPageEvent)event);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Image createImage(PdfImageInfo imageInfo) throws BadElementException, IOException {
        if (imageInfo == null) return null;
        if (StringUtils.isBlank((CharSequence)imageInfo.getUrl())) {
            return null;
        }
        if (imageInfo.getUrl().contains(";base64,")) {
            String base64 = imageInfo.getUrl().split(",")[1];
            byte[] bytes = Base64.getDecoder().decode(base64);
            Image image = Image.getInstance((byte[])bytes);
            image.scaleToFit((float)imageInfo.getWidth().intValue(), (float)imageInfo.getHeight().intValue());
            return image;
        }
        try (InputStream inputStream = PdfUtil.class.getResourceAsStream(imageInfo.getUrl());){
            if (inputStream == null) {
                Image image = null;
                return image;
            }
            byte[] bytes = new byte[inputStream.available()];
            if (inputStream.read(bytes) < 0) {
                Image image = null;
                return image;
            }
            Image image = Image.getInstance((byte[])bytes);
            image.scaleToFit((float)imageInfo.getWidth().intValue(), (float)imageInfo.getHeight().intValue());
            image.setAbsolutePosition((float)imageInfo.getLeft().intValue(), (float)imageInfo.getTop().intValue());
            Image image2 = image;
            return image2;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static PdfPTable createImageTable(PdfCellImageInfo cellImageInfo) throws DocumentException, IOException {
        PdfPTable table = new PdfPTable(1);
        table.setWidths(new float[]{cellImageInfo.getWidth().intValue()});
        int height = 0;
        if (cellImageInfo.getTitle() != null) {
            PdfPCell cell = PdfUtil.createCell(cellImageInfo.getTitle());
            cell.setBorder(2);
            cell.setBorderWidth(0.5f);
            cell.setBorderColor(BaseColor.LIGHT_GRAY);
            table.addCell(cell);
            int n = height = cellImageInfo.getTitle().getHeight() == null ? 40 : cellImageInfo.getTitle().getHeight();
        }
        if (cellImageInfo.getImage() != null) {
            Image image = PdfUtil.createImage(cellImageInfo.getImage());
            PdfPCell imageCell = new PdfPCell(image);
            imageCell.setHorizontalAlignment(1);
            imageCell.setVerticalAlignment(5);
            imageCell.setPadding(0.0f);
            if (cellImageInfo.getImage().getHeight() != null) {
                imageCell.setMinimumHeight((float)cellImageInfo.getHeight().intValue());
            }
            table.addCell(imageCell);
            height += cellImageInfo.getImage().getHeight() == null ? 100 : cellImageInfo.getImage().getHeight();
        }
        if (cellImageInfo.getFooter() != null) {
            PdfPCell footer = PdfUtil.createCell(cellImageInfo.getFooter());
            footer.setBorder(1);
            footer.setBorderColor(BaseColor.LIGHT_GRAY);
            footer.setBorderWidth(0.5f);
            table.addCell(footer);
            height += cellImageInfo.getImage().getHeight() == null ? 40 : cellImageInfo.getImage().getHeight();
        }
        cellImageInfo.setHeight(height);
        return table;
    }

    public static PdfCellInfo buildCellInfo(String text, PdfCellType cellType) {
        if (cellType != null && cellType.equals((Object)PdfCellType.LABEL)) {
            return PdfCellInfo.builder().font(PdfFont.SIM_HEI.code).fontSize(12).bold(false).backgroundColor("#F2F2F2").align(1).build();
        }
        return null;
    }
}

