/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.nsapp.common.core.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.nsapp.common.core.util.EncodingDetect;
import com.geoway.nsapp.common.core.util.GaussXY2BL;
import com.geoway.nsapp.common.core.util.GeometryUtils;
import com.geoway.nsapp.common.core.util.StringUtils;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.referencing.CRS;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ShpUtils {
    private static final String CODE_GBK = "0x4D";
    private static String CGCS2000_GEO = "GEOGCS[\"GCS_CGCS_2000\",DATUM[\"D_GCS_CGCS_2000\",SPHEROID[\"D_China_2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]]";

    public static List<AttributeDescriptor> readShpFields(File shpFile) throws Exception {
        URL url = shpFile.toURI().toURL();
        ShapefileDataStore shpDataStore = new ShapefileDataStore(url);
        Charset charsetZN = ShpUtils.getCharsetByDBF(shpFile);
        shpDataStore.setCharset(charsetZN);
        ContentFeatureSource featureSource = shpDataStore.getFeatureSource(shpDataStore.getTypeNames()[0]);
        FeatureCollection collection = featureSource.getFeatures();
        return ((SimpleFeatureType)collection.getSchema()).getAttributeDescriptors();
    }

    public static JSONArray readShpData(File shpFile) throws Exception {
        JSONArray result = new JSONArray();
        URL url = shpFile.toURI().toURL();
        ShapefileDataStore shpDataStore = new ShapefileDataStore(url);
        ContentFeatureSource featureSource = shpDataStore.getFeatureSource(shpDataStore.getTypeNames()[0]);
        MathTransform mathTransform = null;
        mathTransform = ShpUtils.getTransform(shpFile);
        FeatureCollection collection = featureSource.getFeatures();
        FeatureIterator featureIterator = collection.features();
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            JSONObject dataRow = new JSONObject();
            for (Property property : feature.getValue()) {
                Name name = property.getName();
                Object value = property.getValue();
                if ("the_geom".equals(name.toString())) {
                    Geometry geometry = (Geometry)value;
                    if (mathTransform != null) {
                        value = JTS.transform((Geometry)geometry, (MathTransform)mathTransform);
                    }
                    dataRow.put("wkt", (Object)GeometryUtils.geometryToWkt((Geometry)value));
                }
                dataRow.put(name.toString(), ShpUtils.getCHNValue(value));
            }
            result.add((Object)dataRow);
        }
        return result;
    }

    public static Map readTxt2WKT(File file, String[] fields) throws Exception {
        JSONObject xmxx = new JSONObject();
        JSONArray dkList = new JSONArray();
        xmxx.put("geometries", (Object)dkList);
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, EncodingDetect.detect(file.getPath()));
        BufferedReader reader = new BufferedReader(inputStreamReader);
        JSONObject curDk = null;
        JSONArray curRing = null;
        String curRingIndex = null;
        String text = null;
        while ((text = reader.readLine()) != null) {
            if ("".equals(text = text.trim())) continue;
            if (text.indexOf("=") > 0) {
                String[] pArry = text.split("=");
                if (pArry.length == 0) continue;
                String key = pArry[0];
                String value = null;
                if (pArry.length == 2) {
                    value = pArry[1];
                }
                xmxx.put(key, (Object)(value == null ? null : value.trim()));
                continue;
            }
            String[] pointArry = text.split(",");
            if (pointArry.length < 4) continue;
            boolean bLandStart = text.endsWith("@");
            if (bLandStart) {
                curRingIndex = "-1";
                curDk = new JSONObject();
                for (int i = 0; i < fields.length; ++i) {
                    curDk.put(fields[i], (Object)pointArry[i]);
                }
                curDk.put("rings", (Object)new JSONArray());
                dkList.add((Object)curDk);
                continue;
            }
            String ringIndex = pointArry[1];
            String zbx = xmxx.get((Object)"\u5750\u6807\u7cfb").toString();
            double[] cordinate = new double[]{new Double(pointArry[2]), new Double(pointArry[3])};
            if (!zbx.contains("\u5730\u7406\u5750\u6807\u7cfb")) {
                int num = GaussXY2BL.Beijing54;
                num = zbx.contains("80") ? GaussXY2BL.Xian80 : num;
                num = zbx.contains("2000") ? GaussXY2BL.CGCS2000 : num;
                int mZoneWide = new Integer(xmxx.get((Object)"\u51e0\u5ea6\u5206\u5e26").toString());
                cordinate = GaussXY2BL.GaussToBL(new Double(pointArry[3]), new Double(pointArry[2]), num, mZoneWide);
            }
            if (!ringIndex.equals(curRingIndex)) {
                curRing = new JSONArray();
                JSONArray rings = curDk.getJSONArray("rings");
                rings.add((Object)curRing);
                curRingIndex = ringIndex;
            }
            curRing.add((Object)cordinate);
        }
        JSONObject curJSONOject = null;
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        for (int i = 0; i < dkList.size(); ++i) {
            curJSONOject = (JSONObject)dkList.get(i);
            Geometry geo = ShpUtils.dk2Geometry(curJSONOject, geometryFactory);
            double akArea = geo.getArea();
            String wkt = geo.toText();
            curJSONOject.put("the_geom", (Object)geo);
            curJSONOject.put("wkt", (Object)wkt);
            curJSONOject.put("DKAREA", (Object)akArea);
        }
        reader.close();
        inputStreamReader.close();
        fileInputStream.close();
        return xmxx;
    }

    private static Geometry dk2Geometry(JSONObject dkJSONObj, GeometryFactory geometryFactory) {
        JSONArray dkRings = dkJSONObj.getJSONArray("rings");
        Object dkGeometry = null;
        for (int j = 0; j < dkRings.size(); ++j) {
            JSONArray ring = dkRings.getJSONArray(j);
            Coordinate[] coords = new Coordinate[ring.size()];
            for (int k = 0; k < ring.size(); ++k) {
                Coordinate coord;
                double[] cordinate = (double[])ring.get(k);
                coords[k] = coord = new Coordinate(cordinate[0], cordinate[1]);
            }
            Polygon polygon = geometryFactory.createPolygon(coords);
            dkGeometry = dkGeometry == null ? polygon : (dkGeometry.contains((Geometry)polygon) ? dkGeometry.difference((Geometry)polygon) : dkGeometry.union((Geometry)polygon));
        }
        return dkGeometry;
    }

    private static MathTransform getTransform(File shpFile) throws Exception {
        MathTransform transform = null;
        String cgcsPrj = "";
        String shpPrj = shpFile.getAbsolutePath().replace(".shp", ".prj");
        File prjfile = new File(shpPrj);
        if (prjfile.exists() && StringUtils.isNotBlank((CharSequence)(cgcsPrj = ShpUtils.readSpatialRef(prjfile))) && cgcsPrj.toUpperCase().startsWith("PROJCS")) {
            CoordinateReferenceSystem systemPrj = CRS.parseWKT((String)cgcsPrj);
            CoordinateReferenceSystem systemGeo = CRS.parseWKT((String)CGCS2000_GEO);
            transform = CRS.findMathTransform((CoordinateReferenceSystem)systemPrj, (CoordinateReferenceSystem)systemGeo, (boolean)true);
        }
        return transform;
    }

    private static String readSpatialRef(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        String encode = EncodingDetect.detect(file.getPath());
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, encode);
        BufferedReader reader = new BufferedReader(inputStreamReader);
        String wkt = "";
        String text = null;
        while ((text = reader.readLine()) != null) {
            if (!StringUtils.isNotBlank((CharSequence)(text = text.trim()))) continue;
            wkt = wkt + text;
        }
        return wkt;
    }

    public static Charset getCharsetByDBF(File shpFile) throws Exception {
        Charset charset = StandardCharsets.UTF_8;
        String dbfPath = shpFile.getAbsolutePath().replace(".shp", ".dbf");
        File dbfFile = new File(dbfPath);
        if (dbfFile.exists()) {
            FileInputStream dbf = new FileInputStream(dbfPath);
            byte[] bytes = new byte[30];
            ((InputStream)dbf).read(bytes);
            byte b = bytes[29];
            if (CODE_GBK.equalsIgnoreCase("0x" + Integer.toHexString(Byte.toUnsignedInt(b)))) {
                charset = Charset.forName("GBK");
            }
        } else {
            throw new Exception(".dbf\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        return charset;
    }

    private String checkCharSet(String str) {
        try {
            int lenUtf8 = new String(str.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8).length();
            int lenGbk = new String(str.getBytes(StandardCharsets.ISO_8859_1), "GBK").length();
            if (lenGbk == lenUtf8) {
                return null;
            }
            return lenUtf8 > lenGbk ? "GBK" : "UTF-8";
        }
        catch (Exception exception) {
            return "UTF-8";
        }
    }

    private static Object getCHNValue(Object obj) {
        try {
            if (obj instanceof String) {
                String str = obj.toString();
                String utf8Str = new String(str.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
                String gbkStr = new String(str.getBytes(StandardCharsets.ISO_8859_1), "GBK");
                return utf8Str.length() > gbkStr.length() ? gbkStr : utf8Str;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean createShapeFile(String localDirPath, String fileName, List<Map<String, Object>> data, String geometryFieldName, Integer spatialType) throws Exception {
        if (data == null || data.size() == 0) {
            return false;
        }
        File shpFile = new File(localDirPath + File.separator + fileName + ".shp");
        ShpUtils.generateCpgFile(localDirPath, fileName);
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put(ShapefileDataStoreFactory.URLP.key, shpFile.toURI().toURL());
        ShapefileDataStore dataStore = (ShapefileDataStore)new ShapefileDataStoreFactory().createNewDataStore(params);
        FeatureWriter writer = null;
        try {
            dataStore.setCharset(Charset.forName("GBK"));
            SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
            simpleFeatureTypeBuilder.setCRS(GeometryUtils.getCGCS200CRS());
            simpleFeatureTypeBuilder.setName("shapeFile");
            Set<String> fields = data.get(0).keySet();
            for (String key : fields) {
                if (key.equals(geometryFieldName)) {
                    if (spatialType == 1) {
                        simpleFeatureTypeBuilder.add("the_geom", MultiPoint.class);
                    } else if (spatialType == 2) {
                        simpleFeatureTypeBuilder.add("the_geom", MultiLineString.class);
                    }
                    if (spatialType != 3) continue;
                    simpleFeatureTypeBuilder.add("the_geom", MultiPolygon.class);
                    continue;
                }
                String fieldname = key;
                if (key.length() > 10) {
                    fieldname = fieldname.substring(0, 10);
                }
                simpleFeatureTypeBuilder.add(fieldname, String.class);
            }
            dataStore.createSchema(simpleFeatureTypeBuilder.buildFeatureType());
            WKTReader2 reader = new WKTReader2();
            writer = dataStore.getFeatureWriter(dataStore.getTypeNames()[0], Transaction.AUTO_COMMIT);
            for (Map<String, Object> map : data) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                for (String prop : map.keySet()) {
                    Object value = map.get(prop);
                    if (value == null || StringUtils.isBlank((CharSequence)value.toString())) continue;
                    if (prop.equals(geometryFieldName)) {
                        try {
                            Geometry geo = reader.read(value.toString());
                            feature.setAttribute("the_geom", (Object)geo);
                        }
                        catch (Exception ex) {
                            System.err.println("\u975e\u6cd5\u7684wkt\uff1a" + value);
                        }
                        continue;
                    }
                    String fieldname = prop;
                    if (prop.length() > 10) {
                        fieldname = fieldname.substring(0, 10);
                    }
                    feature.setAttribute(fieldname, (Object)StringUtils.substring(value.toString(), 0, 126));
                }
            }
            writer.write();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            dataStore.dispose();
        }
        return true;
    }

    public static void generateCpgFile(String localDirPath, String fileName) {
        File file = new File(localDirPath + File.separator + fileName + ".cpg");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write("GBK,GB2312,UTF-8");
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        String filePath = "E:\\project\\\u4f5c\u4e1a\u7248app\\\u6587\u6863\\2023\u5e74\u4e13\u9898\u5730\u540d\u6838\u67e5(1000\u4e2a)0017411348546476\\2023\u5e74\u4e13\u9898\u5730\u540d\u6838\u67e5(1000\u4e2a).shp";
        String filePath2 = "E:\\project\\\u4f5c\u4e1a\u7248app\\\u6587\u6863\\\u5730\u4fe1\u5927\u53a6\u5468\u8fb9\\dixindasha.shp";
        ShpUtils.readShpData(new File(filePath));
    }
}

