/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.nsapp.common.core.util;

import java.io.File;
import java.nio.charset.Charset;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Zip4jUtil {
    private static final Logger log = LoggerFactory.getLogger(Zip4jUtil.class);

    public static void zip(File sourceFile, String targetPath) {
        Zip4jUtil.zip(sourceFile, targetPath, null);
    }

    public static void unzip(File sourceFile, String targetPath) {
        Zip4jUtil.unzip(sourceFile, targetPath, "");
    }

    public static void zip(File sourceFile, String targetPath, String password) {
        File targetFile = new File(targetPath);
        ZipParameters zipParameters = new ZipParameters();
        ZipFile zipFile = new ZipFile(targetFile);
        zipFile.setCharset(Charset.forName("GBK"));
        if (StringUtils.isNotBlank((CharSequence)password)) {
            zipParameters.setEncryptFiles(true);
            zipParameters.setEncryptionMethod(EncryptionMethod.AES);
            zipParameters.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);
            zipFile.setPassword(password.toCharArray());
        }
        try {
            zipFile.addFile(sourceFile, zipParameters);
        }
        catch (Exception e) {
            log.error("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public static void unzip(File sourceFile, String targetPath, String password) {
        File dir = new File(targetPath);
        if (!dir.exists()) {
            dir.mkdir();
        }
        ZipFile zipFile = new ZipFile(sourceFile);
        zipFile.setCharset(Charset.forName("GBK"));
        try {
            if (zipFile.isEncrypted()) {
                zipFile.setPassword(password.toCharArray());
            }
            zipFile.extractAll(targetPath);
        }
        catch (ZipException e) {
            log.error("\u89e3\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public static void main(String[] args) throws Exception {
        String filePath = "E:\\TestData\\\u5730\u4fe1\u5927\u53a6\u5468\u8fb9.zip";
        String targetPath = "E:\\TestData\\\u5730\u4fe1\u5927\u53a6\u5468\u8fb9";
        Zip4jUtil.unzip(new File(filePath), targetPath, "");
    }
}

