package com.geoway.nsapp.common.data.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author by wangqiang
 * @date 2023/12/4.
 */
@Mapper
public interface DataBizMapper {

    /**
     * 根据自定义sql语句查询数据
     *
     * @param sql
     * @return
     */
    List<Map> queryDataBySql(@Param("sql") String sql);

    /**
     * 根据表名称查询所有字段值
     *
     * @param tableName 表名称
     * @return
     */
    List<Map<String, Object>> queryAllData(
            @Param("tableName") String tableName,
            @Param("fieldList") List<String> fieldList,
            @Param("where") String where);

    List<Map<String, Object>> queryDataAllFields(
            @Param("tableName") String tableName,
            @Param("where") String where);

    /**
     * 相交查询
     * @param tableName
     * @param fieldList
     * @param wkt
     * @return
     */
    List<Map<String, Object>> queryByIntersect(
            @Param("tableName") String tableName,
            @Param("fieldList") List<String> fieldList,
            @Param("wkt") String wkt,
            @Param("batchId") String batchId);

    /**
     * 查询分页数据
     *
     * @param page      分页对象
     * @param tableName 表名称
     * @param fieldList 字段列表
     * @param where     条件
     * @return 分页数据
     */
    Page<Map<String, Object>> queryPageData(
            Page<Map<String, Object>> page,
            @Param("tableName") String tableName,
            @Param("fieldList") List<String> fieldList,
            @Param("where") String where,
            @Param("order") String order);

    /**
     * 查找表中某一字段最大值
     *
     * @param fieldName
     * @param tableName
     * @return
     */
    Long selectMaxValue(@Param("fieldName") String fieldName, @Param("tableName") String tableName);

    /**
     * 根据ID查询数据对象
     *
     * @param tableName    表名称
     * @param fieldList    字段列表
     * @param primaryField 表主键字段名称
     * @param id           主键值
     * @return
     */
    Map<String, Object> queryByID(
            @Param("tableName") String tableName,
            @Param("fieldList") List<String> fieldList,
            @Param("primaryField") String primaryField,
            @Param("id") String id);

    /**
     * 根据ID查询数据对象
     *
     * @param tableName    表名称
     * @param primaryField 表主键字段名称
     * @param id           主键值
     * @return
     */
    Map selectByID(
            @Param("tableName") String tableName,
            @Param("primaryField") String primaryField,
            @Param("id") String id);

    String getWktById(
            @Param("tableName") String tableName,
            @Param("primaryField") String primaryField,
            @Param("id") String id);

    /**
     * 查询数据总数量
     *
     * @param tableName 表名称
     * @param where     条件
     * @return 数量
     */
    int getCount(@Param("tableName") String tableName, @Param("where") String where);

    /**
     * 插入数据
     *
     * @param tableName 表名称
     * @param map       数据Map对象
     * @return
     */
    int insert(
            @Param("tableName") String tableName,
            @Param("map") Map<String, Object> map);

    int insertDataByTimeStamp(
            @Param("tableName") String tableName,
            @Param("map") Map<String, Object> map,
            @Param("geofield") String geofield);

    /**
     * 批量插入输入
     *
     * @param tableName 表名称
     * @param valueList 数据集合
     * @param geofield  shp数据字段key
     * @return
     */
    int insertBatch(
            @Param("tableName") String tableName,
            @Param("valueList") List<Map<String, Object>> valueList,
            @Param("geofield") String geofield);

    int insertBatchByTimeStamp(
            @Param("tableName") String tableName,
            @Param("valueList") List<Map<String, Object>> valueList,
            @Param("geofield") String geofield);

    /**
     * 更新数据
     *
     * @param tableName 表名称
     * @param tableName 表名称
     * @param map       更新值的Map对象
     * @param where     条件
     * @return
     */
    int update(
            @Param("tableName") String tableName,
            @Param("map") Map<String, Object> map,
            @Param("where") String where);

    /**
     *
     * @param tableName
     * @param map
     * @return
     */
    int updateBatch(
            @Param("tableName") String tableName,
            @Param("list")  List<Map<String, Object>> map);

    /**
     * 删除数据
     *
     * @param tableName    表名称
     * @param primaryField 表主键字段名称
     * @param id           主键值
     * @return
     */
    int delete(
            @Param("tableName") String tableName,
            @Param("primaryField") String primaryField,
            @Param("id") String id);

    /**
     * 根据条件删除数据
     *
     * @param tableName 表名称
     * @param where     删除条件
     * @return
     */
    int deleteByCond(@Param("tableName") String tableName, @Param("where") String where);

    /**
     * 根据sql执行更新
     *
     * @param tableName 表名称
     * @param sql       更新语句
     * @param where     更新条件
     * @return
     */
    int updateBySql(
            @Param("tableName") String tableName, @Param("sql") String sql, @Param("where") String where);

    void createTable(
            @Param("tableName") String tableName,
            @Param("fieldSql") String fieldSql,
            @Param("indexSql") String indexSql);

    int existSequence(@Param("sequenceName") String sequenceName);

    void createSequence(@Param("sequenceName") String sequenceName);

    int getNextVal(@Param("sequenceName") String sequenceName);

    @Delete("DROP TABLE IF EXISTS ${tableName}")
    void dropTable(String tableName);
}
