package com.geoway.nsapp.common.data.po;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author by wangqiang
 * @date 2023/12/13.
 */
@Data
public class TableField {
    /** 字段名称 */
    @ApiModelProperty(value = "字段名称")
    private String fieldName;

    /** 字段别名 */
    @ApiModelProperty(value = "字段别名")
    private String aliasName;

    /**
     * 数据类型 [{name:'长文本',id:'1'},{name:'短文本',id:'2'},{name:'数字',id:'3'},{name:'日期',id:'4'},
     * {name:'时间',id:'5'},{name:'编号',id:'6'},{name:'面积',id:'7'},{name:'整数',id:'8'},{name:'空间字段',id:'9'},{name:'签名',id:'10'}]
     *
     * <p>1 text 2 varchar, 3 decimal, 4 timestamp, 5 timestamp, 6 varchar, 7 decimal,8 int4,9
     * geometry,10 text
     */
    @ApiModelProperty(
            value =
                    "数据类型 [{name:'长文本',id:'1'},{name:'短文本',id:'2'},{name:'数字',id:'3'},{name:'日期',id:'4'},       {name:'时间',id:'5'},{name:'编号',id:'6'},{name:'面积',id:'7'},{name:'整数',id:'8'},{name:'空间字段',id:'9'},{name:'签名',id:'10'}],,1 text 2 varchar, 3 decimal, 4 timestamp, 5 timestamp, 6 varchar, 7 decimal,8 int4,9 geometry,10 text")
    private String fieldType;

    /** 字段长度 */
    @ApiModelProperty(value = "字段长度")
    private Integer length;

    /** 精度 */
    @ApiModelProperty(value = "精度")
    private Integer precision;

    /** 是否允许为空（1：可以为空， 0：不能为空） */
    @ApiModelProperty(value = "是否允许为空（1：可以为空， 0：不能为空）")
    private Integer nullAble;

    /** 默认值 */
    @ApiModelProperty(value = "默认值")
    private String defaultValue;
}
