package com.geoway.nsapp.common.data.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author by wangqiang
 * @date 2023/12/4.
 */
public interface DataBizService {
    String getWktById(String tableName,String primaryFieldName,String id);

    Map<String, Object> queryById(String tableName, List<String> fieldList, String primaryFieldName, String id);

    // 未处理空间字段，如果表有空间字段使用queryById
    Map selectByID(String tableName, String primaryFieldName, String id);

    void createTable(String tableName, String fieldSql, String indexSql);

    List<Map<String, Object>> queryAllData(String tableName, List<String> fieldList, String where);

    // 被查询表不能有空间字段
    List<Map<String, Object>> queryDataAllFields(String tableName, String where);

    List<Map<String, Object>> queryByIntersect(String tableName, List<String> fieldList, String wkt,String batchId);

    /**
     * 分页查询
     *
     * @param tableName 表名
     * @param fieldList 模板字段列表
     * @param pageSize  每页大小
     * @param pageNum   页码
     * @param where     查询条件
     * @return 分页数据
     */
    Page<Map<String, Object>> queryPageData(String tableName, List<String> fieldList, int pageSize, int pageNum, String where, String order);

    int insertData(String tableName, Map<String, Object> map);

    int updateData(String tableName, Map<String, Object> map, String where);

    int updateDataById(String tableName, String id, Map<String, Object> map);

    boolean isExistTableName(String tableName);

    int getCount(String tableName, String where);

    int existSequence(String sequenceName);

    void createSequence(String sequenceName);

    int getNextVal(String sequenceName);

    int getTableNextVal(String tableName);

    int updateBatch(String tableName,List<Map<String, Object>> map);

    int delete(String tableName, String primaryField, String id);

    void dropTable(String tablename);
}
