package com.geoway.nsapp.common.data.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.atlas.license.authorize.LicenseCheck;
import com.geoway.nsapp.common.data.mapper.DataBizMapper;
import com.geoway.nsapp.common.data.service.DataBizService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Description 数据处理服务类
 * @Date 2023/3/6 17:30
 * @return
 */
@Service
public class DataBizServiceImpl implements DataBizService {

    @Resource
    DataBizMapper dataBizMapper;

    static {
        synchronized (LicenseCheck.class) {
            LicenseCheck.isValid(65035);
        }
    }

    /**
     * 未处理空间字段，如果表有空间字段使用queryById
     * 根据ID查询数据对象
     *
     * @param tableName        表名称
     * @param primaryFieldName 表主键字段名称
     * @param id               主键值
     * @return
     */
    @Deprecated
    @Override
    public Map selectByID(String tableName, String primaryFieldName, String id) {
        return dataBizMapper.selectByID(tableName, primaryFieldName, "'" + id + "'");
    }

    @Override
    public String getWktById(String tableName,String primaryFieldName, String id) {
        return dataBizMapper.getWktById(tableName, primaryFieldName, "'" + id + "'");
    }

    /**
     * 根据ID查询数据对象
     *
     * @param tableName        表名称
     * @param fieldList        字段列表
     * @param primaryFieldName 表主键字段名称
     * @param id               主键值
     * @return 数据对象
     */
    @Override
    public Map<String, Object> queryById(String tableName, List<String> fieldList,
                                         String primaryFieldName, String id) {
        return dataBizMapper.queryByID(tableName, fieldList, primaryFieldName, id);
    }

    /**
     * @return void
     * @Author tangxin
     * @Description 创建表
     * @Date 2023/3/8 11:59
     */
    @Override
    public void createTable(String tableName, String fieldSql, String indexSql) {
        dataBizMapper.createTable(tableName, fieldSql, indexSql);
    }

    @Override
    public List<Map<String, Object>> queryAllData(String tableName, List<String> fieldList, String where) {
        return dataBizMapper.queryAllData(tableName, fieldList, where);
    }

    @Override
    public List<Map<String, Object>> queryDataAllFields(String tableName, String where) {
        return dataBizMapper.queryDataAllFields(tableName, where);
    }

    @Override
    public List<Map<String, Object>> queryByIntersect(String tableName, List<String> fieldList, String wkt,String batchId) {
        return dataBizMapper.queryByIntersect(tableName, fieldList, wkt,batchId);
    }

    @Override
    public Page<Map<String, Object>> queryPageData(String tableName, List<String> fieldList,
                                                   int pageSize, int pageNum, String where, String order) {
        Page<Map<String, Object>> page = new Page<>(pageNum, pageSize);
        return dataBizMapper.queryPageData(page, tableName, fieldList, where,order);
    }

    /**
     * 插入数据
     *
     * @param tableName 表名称
     * @param map       数据Map对象
     * @return
     */
    @Override
    public int insertData(String tableName, Map<String, Object> map) {

        int insert = 0;
        insert = dataBizMapper.insert(tableName, map);

        return insert;
    }

    @Override
    public int updateData(String tableName, Map<String, Object> map, String where) {
        int insert = dataBizMapper.update(tableName, map, where);
        return insert;
    }

    /**
     * 更新数据
     *
     * @param tableName 表名称
     * @param id        Id
     * @param map       更新值的Map对象
     * @return
     */
    @Override
    public int updateDataById(String tableName, String id, Map<String, Object> map) {
        return updateData(tableName, map, "f_id='" + id + "'");
    }

    /**
     * 判断表是否存在
     *
     * @param tableName 表名称
     * @return
     */
    @Override
    public boolean isExistTableName(String tableName) {
        String sql = "select count(*) as c from pg_class where relname = '" + tableName + "'";
        return ((Long) dataBizMapper.queryDataBySql(sql).get(0).get("c")) > 0;
    }

    @Override
    public int getCount(String tableName, String where) {
        return dataBizMapper.getCount(tableName, where);
    }

    @Override
    public int existSequence(String sequenceName) {
        return dataBizMapper.existSequence(sequenceName);
    }

    @Override
    public void createSequence(String sequenceName) {
        dataBizMapper.createSequence(sequenceName);
    }

    @Override
    public int getNextVal(String sequenceName) {
        return dataBizMapper.getNextVal(sequenceName);
    }

    @Override
    public int getTableNextVal(String tableName) {
        String sequenceName = tableName + "_auto_seq";
        int count = dataBizMapper.existSequence(sequenceName);
        if (count == 0) {
            dataBizMapper.createSequence(sequenceName);
        }
        return dataBizMapper.getNextVal(sequenceName);
    }

    @Override
    public int updateBatch(String tableName, List<Map<String, Object>> map) {
        return dataBizMapper.updateBatch(tableName,map);
    }

    @Override
    public int delete(String tableName, String primaryField, String id) {
        int delete = dataBizMapper.delete(tableName, primaryField, id);
        return delete;
    }

    @Override
    public void dropTable(String tablename){
        dataBizMapper.dropTable(tablename);
    }
}
