package com.geoway.nsapp.common.file.dto;

import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.geoway.nsapp.common.core.base.domain.RestResult;
import com.geoway.nsapp.common.core.base.dto.FileUploadResponse;
import lombok.Data;

@Data
public class FileServerResponse extends RestResult {

    private Integer serverId;

    private String serverURL;

    private String bucket;

    private String path;

    private String thumailPath;

    private Long fileSize;

    private String fileType;

    private String previewURL;

    private String viewUrl;

    public FileUploadResponse convertToFileUploadResponse() {
        FileUploadResponse fileUploadResponse = new FileUploadResponse();
        fileUploadResponse.setAbsolutePath(bucket + Constants.AT + path);
        fileUploadResponse.setObjectUrl(serverURL + "/" + bucket + "/" + path);
        fileUploadResponse.setRelativePath(path);

        return fileUploadResponse;

    }

}
