package com.geoway.nsapp.common.file.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * @TableName tbsys_file
 */
@TableName(value ="tbsys_file")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class File implements Serializable {
    /**
     * id
     */
    @TableId(value = "f_id",type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 关联id
     */
    @TableField(value = "f_relation_id")
    @ApiModelProperty(value = "关联id")
    private String relationId;

    /**
     * 完整访问地址
     */
    @TableField(value = "f_url")
    @ApiModelProperty(value = "访问地址")
    private String url;

    /**
     * 存储路径
     */
    @TableField(value = "f_path")
    @ApiModelProperty(value = "路径")
    private String path;

    /**
     * 业务类型
     */
    @TableField(value = "f_type")
    @ApiModelProperty(value = "业务类型")
    private String type;

    /**
     * 文件名
     */
    @TableField(value = "f_name")
    private String name;

    /**
     * 上传时间
     */
    @TableField(value = "f_create_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(hidden = true)
    private Date createTime;

    /**
     * 媒体类型
     */
    @TableField(value = "f_media_type")
    private Integer mediaType;

    /**
     * 上传人id
     */
    @TableField(value = "f_creator_id")
    private String creatorId;

    /**
     * 上传人名称
     */
    @TableField(value = "f_creator_name")
    private String creatorName;

    /**
     * 文件服务器
     */
    @TableField(value = "f_file_serverid")
    private String fileServerId;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}