package com.geoway.nsapp.common.file.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;

/**
 * @TableName tbsys_fileserver
 */
@TableName(value = "tbsys_fileserver")
@Data
public class FileServer implements Serializable {
    /**
     *
     */
    @TableId(value = "f_id", type = IdType.NONE)
    private Integer id;

    /**
     *
     */
    @TableField(value = "f_name")
    private String name;

    /**
     *
     */
    @TableField(value = "f_url")
    private String url;
    /**
     *
     */
    @TableField(value = "f_endpoint")
    private String endpoint;

    /**
     * 存储桶（根目录）
     */
    @TableField(value = "f_bucket")
    private String bucket;


    /**
     *
     */
    @TableField(value = "f_appkey")
    private String appkey;

    /**
     *
     */
    @TableField(value = "f_appsecret")
    private String appsecret;

    /**
     *
     */
    @TableField(value = "f_token")
    private String token;

    /**
     * 服务类型: nginx,minio,obs等
     */
    @TableField(value = "f_type")
    private String type;

    /**
     * 是否默认
     */
    @TableField(value = "f_isdefault")
    private Integer isdefault;

    /**
     * 其他需要存储信息
     */
    @TableField(value = "f_param")
    private String param;

    /**
     * 是否默认
     */
    @TableField(value = "f_ispublic")
    private Integer ispublic;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}