package com.geoway.nsapp.common.file.service;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClient;
import com.geoway.nsapp.common.file.dto.FileDownloadMeta;
import com.geoway.nsapp.common.file.dto.FileStoreMeta;
import com.geoway.nsapp.common.file.entity.FileServer;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;

/**
 * @author daidongdong
 * @description 针对OBS服务的文件相关操作
 * @createDate 2022-06-29 15:24:19
 */
public interface AliOssFileService {

    OSS getOssClient(FileServer fileServer) throws Exception;

    FileStoreMeta sendFile(FileServer fileServer, MultipartFile file, String objectName) throws Exception;

    FileStoreMeta sendFile(FileServer fileServer, File file, String objectName) throws Exception;

    FileStoreMeta buildThumbnailFile(FileServer fileServer, String objectName) throws Exception;

    void deleteFile(FileServer fileServer, String bucket, String path) throws Exception;

    String buildPreviewURL(FileServer fileServer, String objectName, Integer expires) throws Exception;

    String getPreviewURL(FileServer fileServer, String url, Integer expires) throws Exception;

    byte[] createThumbnail(FileServer fileServer, String objectName) throws Exception;

    FileDownloadMeta downLoadFile(FileServer fileServer, String objectName) throws Exception;
}
