package com.geoway.nsapp.common.file.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.nsapp.common.file.dto.FileDownloadMeta;
import com.geoway.nsapp.common.file.dto.FileServerResponse;
import com.geoway.nsapp.common.file.entity.FileServer;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.InputStream;

/**
 * @author daidongdong
 * @description 针对表【tbsys_fileserver】的数据库操作Service
 * @createDate 2022-06-29 15:24:19
 */
public interface FileServerService extends IService<FileServer> {

    FileServerResponse sendFileToServer(MultipartFile file) throws Exception;

    FileServerResponse sendFileToServer(MultipartFile file, boolean buildThumbnail) throws Exception;

    FileServerResponse sendFileToServer(MultipartFile file, String objectName, boolean buildThumbnail) throws Exception;

    FileServerResponse sendFileToServer(File file, String objectName, boolean buildThumbnail) throws Exception;

    FileServerResponse sendFileToServer(String serverId, MultipartFile file, String objectName, boolean buildThumbnail) throws Exception;

    FileServerResponse sendFileToServer(String serverId, File file, String objectName, boolean buildThumbnail) throws Exception;

    FileServerResponse sendFileToServerOnSpeFolder(MultipartFile file, String foldName) throws Exception;

    FileServerResponse sendFileToServerOnSpeFolder(MultipartFile file, String foldName, boolean buildThumbnail) throws Exception;

    /**
     * 文件流上传
     *
     * @param stream
     * @param objectName  文件名
     * @param contentType 文件类型
     * @return
     */
    FileServerResponse sendFileToServerByStream(InputStream stream, String objectName, String contentType) throws Exception;

    void deleteFile(String objectName) throws Exception;

    void deleteFile(Integer serverId, String objectName) throws Exception;

    FileServer findDefault();

    FileServer findById(Integer id);

    /**
     * 创建预览地址
     *
     * @param serverId
     * @param objectName
     * @return
     * @throws Exception
     */
    String buildPreviewURL(Integer serverId, String objectName, Integer expires) throws Exception;

    String getPreviewURL(Integer serverId,String url, Integer expires) throws Exception;

    /**
     * 创建缩略图（目前只支持图片类型）
     *
     * @param serverId
     * @param objectName
     * @return
     */
    byte[] createThumail(Integer serverId, String objectName) throws Exception;

    FileDownloadMeta queryDownLoadMeta(Integer serverId, String objectName) throws Exception;

    FileDownloadMeta queryDownLoadMeta(String objectName) throws Exception;

    void deleteCache();

    FileServer saveOne(FileServer fileServer);

    void setDefault(Integer serverId);
}
