package com.geoway.nsapp.common.file.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.nsapp.common.file.dto.FileSaveDto;
import com.geoway.nsapp.common.file.entity.File;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
* @author wangqiang
* @description 针对表【tbsys_file】的数据库操作Service
* @createDate 2023-12-07 16:52:47
*/
@Transactional(rollbackFor = Exception.class)
public interface FileService extends IService<File> {

    List<File> queryList(String rid, String type,String name);

    String saveInfo(FileSaveDto file, JSONObject userInfo);

    Boolean saveBatchInfo(List<FileSaveDto> infos,JSONObject userInfo);

    Boolean deleteInfo(String id);

}
