package com.geoway.nsapp.common.file.service;

import com.geoway.nsapp.common.file.dto.FileDownloadMeta;
import com.geoway.nsapp.common.file.dto.FileStoreMeta;
import com.geoway.nsapp.common.file.entity.FileServer;
import io.minio.MinioClient;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.InputStream;

/**
 * @author daidongdong
 * @description 针对minio服务的文件相关操作
 * @createDate 2022-06-29 15:24:19
 */
public interface MinIOFileService {

    MinioClient getOssClient(FileServer fileServer);

    FileStoreMeta sendFile(FileServer fileServer, File file, String objectName) throws Exception;

    /**
     * 流上传
     * @param fileServer
     * @param objectName
     * @return
     * @throws Exception
     */
    FileStoreMeta sendFile(FileServer fileServer, MultipartFile multipartFile, String objectName) throws Exception;

    FileStoreMeta buildThumbnailFile(FileServer fileServer, String objectName) throws Exception;

    void deleteFile(FileServer fileServer, String bucket, String path) throws Exception;

    String buildPreviewURL(FileServer fileServer, String objectName, Integer expires) throws Exception;

    String getPreviewURL(FileServer fileServer, String url, Integer expires) throws Exception;

    byte[] createThumbnail(FileServer fileServer, String objectName) throws Exception;

    FileDownloadMeta downLoadFile(FileServer fileServer, String objectName) throws Exception;
}
