package com.geoway.nsapp.common.file.service;

import com.geoway.nsapp.common.file.dto.FileDownloadMeta;
import com.geoway.nsapp.common.file.dto.FileStoreMeta;
import com.geoway.nsapp.common.file.entity.FileServer;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;

/**
 * @author daidongdong
 * @description 针对共享服务的文件相关操作
 * @createDate 2022-06-29 15:24:19
 */
public interface ShareFileService {

    FileStoreMeta sendFile(FileServer fileServer, MultipartFile file, String objectName) throws IOException;

    FileStoreMeta buildThumbnailFile(FileServer fileServer, String objectName) throws IOException;

    void deleteFile(FileServer fileServer, String objectName) throws IOException;

    String buildPreviewURL(FileServer fileServer, String objectName, Integer expires) throws Exception;

    byte[] createThumbnail(FileServer fileServer, String objectName) throws Exception;

    FileDownloadMeta downLoadFile(FileServer fileServer, String objectName) throws Exception;
}
