package com.geoway.nsapp.common.file.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.nsapp.common.core.base.service.BaseService;
import com.geoway.nsapp.common.core.exception.ServiceException;
import com.geoway.nsapp.common.file.dto.FileSaveDto;
import com.geoway.nsapp.common.file.entity.File;
import com.geoway.nsapp.common.file.mapper.FileMapper;
import com.geoway.nsapp.common.file.service.FileService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
* @author wangqiang
* @description 针对表【tbsys_file】的数据库操作Service实现
* @createDate 2023-12-07 16:52:47
*/
@Service
public class FileServiceImpl extends ServiceImpl<FileMapper, File>
    implements FileService {

    @Override
    public String saveInfo(FileSaveDto infoDto, JSONObject userInfo) {
        File info = BaseService.convertToDO(infoDto,new File());
        info.setCreateTime(new Date());
        info.setCreatorId(userInfo.getString("id"));
        info.setCreatorName(userInfo.getString("rname"));
        info.setFileServerId(infoDto.getFileServerId());
        this.save(info);
        return info.getId();
    }

    @Override
    public Boolean saveBatchInfo(List<FileSaveDto> filesDto, JSONObject userInfo) {
        List<File> files = new ArrayList<>();
        if(!BeanUtil.isEmpty(filesDto)){
            filesDto.forEach( l -> {
                File info = BaseService.convertToDO(l,new File());
                info.setCreateTime(new Date());
                info.setCreatorId(userInfo.getString("id"));
                info.setCreatorName(userInfo.getString("rname"));
                info.setFileServerId(l.getFileServerId());
                files.add(info);
            });
            return saveOrUpdateBatch(files);
        }else {
            throw new ServiceException("数据为空！");
        }
    }

    @Override
    public List<File> queryList(String rid,String type,String name) {
        LambdaQueryWrapper<File> wrapper = Wrappers.lambdaQuery(File.class).eq(File::getRelationId, rid);
        if(StringUtils.isNotEmpty(type)){
            wrapper.in(File::getType,type.split(","));
        }
        if(StringUtils.isNotEmpty(name)){
            wrapper.like(File::getName,name);
        }
        return this.list(wrapper);
    }

    @Override
    public Boolean deleteInfo(String id) {
        return removeById(id);
    }
}




