package com.geoway.nsapp.common.file.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.util.FileUtils;
import com.geoway.nsapp.common.file.dto.FileDownloadMeta;
import com.geoway.nsapp.common.file.dto.FileStoreMeta;
import com.geoway.nsapp.common.file.entity.FileServer;
import com.geoway.nsapp.common.file.service.ShareFileService;
import com.geoway.nsapp.common.file.util.ObjectKeyUtil;
import lombok.extern.slf4j.Slf4j;
import net.coobird.thumbnailator.Thumbnails;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

/**
 * @author daidd
 */
@Service
@Slf4j
public class ShareFileServiceImpl implements ShareFileService {

    @Value("${project.workDir:/data}")
    protected String workDir;

    @Override
    public FileStoreMeta sendFile(FileServer fileServer, MultipartFile file, String objectName) throws IOException {
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        // 获取文件全称
        String fileName = file.getOriginalFilename();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();

        if (StrUtil.isBlank(objectName)) {
            objectName = ObjectKeyUtil.formatObjectName(fileName);
        }

        String storeFilePath = storePath + File.separator + bucket + File.separator + objectName;
        File storeFile = new File(storeFilePath);

        File dir = storeFile.getParentFile();
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                log.info("----创建共享文件夹目录成功----");
            } else {
                log.error("----创建共享文件夹目录失败，请联系管理员！----");
            }
        }


        file.transferTo(storeFile);

        fileStoreMeta.setAbsolutePath(fileServer.getUrl() + "/" + objectName);
        fileStoreMeta.setRelPath(objectName);
        fileStoreMeta.setName(fileName);
        fileStoreMeta.setFileSize(storeFile.length());
        fileStoreMeta.setFileType(fileType);


        return fileStoreMeta;
    }


    @Override
    public FileStoreMeta buildThumbnailFile(FileServer fileServer, String objectName) throws IOException {

        FileStoreMeta fileStoreMeta = new FileStoreMeta();

        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();
        String storeFilePath = storePath + File.separator + bucket + File.separator + objectName;
        File file = new File(storeFilePath);
        // 上传文件类型
        String fileType = objectName.substring(objectName.lastIndexOf(".") + 1).toLowerCase();
        String[] photoTypes = {"png", "jpg", "jpeg", "bmp"};
        boolean photoflag = Arrays.stream(photoTypes).anyMatch(type -> type.equalsIgnoreCase(fileType));

        if (photoflag) {
            String minObjectName = objectName.replace("." + fileType, "-min." + fileType);
            String minFilePath = storePath + File.separator + bucket + File.separator + minObjectName;
            File thunmailFile = new File(minFilePath);
            Thumbnails.of(file).scale(0.1).toFile(thunmailFile);

            fileStoreMeta.setAbsolutePath(fileServer.getUrl() + "/" + minObjectName);
            fileStoreMeta.setName(thunmailFile.getName());
            fileStoreMeta.setFileSize(thunmailFile.length());
            fileStoreMeta.setFileType(fileType);
            fileStoreMeta.setRelPath(minObjectName);
        }
        //处理PDF缩略图
        boolean pdfFlag = "pdf".equalsIgnoreCase(fileType);
        if (pdfFlag) {

        }
        //处理office缩略图
        String[] officeTypes = {"doc", "docx", "xls", "xlsx", "ppt", "pptx"};
        boolean officeFlag = Arrays.stream(officeTypes).anyMatch(type -> type.equalsIgnoreCase(fileType));
        if (officeFlag) {

        }
        //处理视频缩略图
        String[] videoTypes = {"mp4", "avi"};
        boolean videoFlag = Arrays.stream(videoTypes).anyMatch(type -> type.equalsIgnoreCase(fileType));
        if (videoFlag) {

        }

        return fileStoreMeta;
    }

    @Override
    public void deleteFile(FileServer fileServer, String objectName) throws IOException {

        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();
        String storeFilePath = storePath + File.separator + bucket + File.separator + objectName;
        File file = new File(storeFilePath);
        file.delete();
    }

    @Override
    public String buildPreviewURL(FileServer fileServer, String objectName, Integer expires) throws Exception {
        String url = fileServer.getUrl() + "/" + objectName;

        return url;
    }

    @Override
    public byte[] createThumbnail(FileServer fileServer, String objectName) throws Exception {
        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();
        String storeFilePath = storePath + File.separator + bucket + File.separator + objectName;
        File file = new File(storeFilePath);

        String minFilePath = workDir + File.separator + objectName;
        File thunmailFile = new File(minFilePath);
        File pParentFile = thunmailFile.getParentFile();
        if (!pParentFile.exists()) {
            pParentFile.mkdirs();
        }
        Thumbnails.of(file).scale(0.1).toFile(thunmailFile);

        byte[] thumnailBytes = FileUtils.readFileToByteArray(thunmailFile);
        thunmailFile.delete();

        return thumnailBytes;
    }

    @Override
    public FileDownloadMeta downLoadFile(FileServer fileServer, String objectName) throws Exception {

        FileDownloadMeta fileDownloadMeta = new FileDownloadMeta();

        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();
        String storeFilePath = storePath + File.separator + bucket + File.separator + objectName;
        File file = new File(storeFilePath);


        InputStream inputStream = new FileInputStream(file);
        fileDownloadMeta.setFileSize(file.length());
        fileDownloadMeta.setInputStream(inputStream);

        return fileDownloadMeta;
    }
}
