package com.geoway.nsapp.common.file.util;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class ObjectKeyUtil {

    public static String formatObjectName(String fileName) {
        String objectName;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String foldName = simpleDateFormat.format(new Date());

        String subFoldName = "other";
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        String[] photoTypes = {"png", "jpg", "jpeg", "bmp", "gif"};
        boolean photoflag = Arrays.stream(photoTypes).anyMatch(type -> type.equalsIgnoreCase(fileType));
        if (photoflag) {
            subFoldName = "photo";
        }

        String[] officeTypes = {"doc", "docx", "xls", "xlsx", "ppt", "pptx"};
        boolean officeFlag = Arrays.stream(officeTypes).anyMatch(type -> type.equalsIgnoreCase(fileType));
        if (officeFlag) {
            subFoldName = "office";
        }

        String[] videoTypes = {"mp4", "avi", "mov", "rmvb", "mkv", "flv", "wmv", "3gp"};
        boolean videoFlag = Arrays.stream(videoTypes).anyMatch(type -> type.equalsIgnoreCase(fileType));
        if (videoFlag) {
            subFoldName = "video";
        }
        if ("pdf".equals(fileType)) {
            subFoldName = "pdf";
        }

        objectName = foldName + "/" + subFoldName + "/" + System.currentTimeMillis() + "-" + fileName;

        return objectName;
    }

}
