/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ue.common.data.response;

import com.geoway.ue.common.constant.ResultCode;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class BaseResponse {
    static final String OK = "ok";
    static final String ERROR = "error";
    private String status;
    private String message;

    public static ResponseEntity<BaseResponse> ok() {
        return ResponseEntity.ok((Object)new BaseResponse(OK, ""));
    }

    public static ResponseEntity<BaseResponse> error(String message) {
        return new ResponseEntity((Object)new BaseResponse(ERROR, message), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static ResponseEntity<BaseResponse> error(ResultCode res) {
        return BaseResponse.error(res.getDesc(), res.getCode());
    }

    public static ResponseEntity<BaseResponse> error(String message, int httpStatus) {
        return new ResponseEntity((Object)new BaseResponse(ERROR, message), null, httpStatus);
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResponse)) {
            return false;
        }
        BaseResponse other = (BaseResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "BaseResponse(status=" + this.getStatus() + ", message=" + this.getMessage() + ")";
    }

    public BaseResponse() {
    }

    public BaseResponse(String status, String message) {
        this.status = status;
        this.message = message;
    }
}

