/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.filechannel;

import com.alibaba.fastjson.JSON;
import com.geoway.vtile.commons.filechannel.FileInfo;
import com.geoway.vtile.commons.filechannel.SplitFilePart;
import com.geoway.vtile.commons.util.FileUtil;
import com.geoway.vtile.commons.util.StringUtility;
import com.geoway.vtile.commons.util.ThreadLocalMD5;
import com.geoway.vtile.commons.util.UString;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutilPartFileChannelReader
implements AutoCloseable {
    private String infoJsonPath;
    private FileInfo fileInfo;
    private ThreadLocalMD5 MD5 = new ThreadLocalMD5();
    private long offset = 0L;
    private long size = 0L;
    private FileChannel currentReaderChannel;
    private int partIndex = 0;
    private int partNum;
    private String root = null;
    Logger logger = LoggerFactory.getLogger(MutilPartFileChannelReader.class);

    public MutilPartFileChannelReader(String infoJsonPath) throws Exception {
        this.infoJsonPath = infoJsonPath;
        this.fileInfo = this.createFileInfo(this.infoJsonPath);
        this.init();
    }

    public MutilPartFileChannelReader(FileInfo fileInfo) throws Exception {
        this.fileInfo = fileInfo;
        this.init();
    }

    private void init() throws Exception {
        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d" + this.infoJsonPath);
        this.checkMD5(this.fileInfo);
        this.size = this.fileInfo.getPart().stream().mapToLong(SplitFilePart::getPartSize).sum();
        this.partNum = this.fileInfo.getPart().size();
        this.logger.debug(UString.format("\u5206\u6587\u4ef6 {} \u4e2a\uff0c\u603b\u5927\u5c0f\u4e3a {} ", this.partNum, StringUtility.getDataSize(this.size)));
    }

    private FileInfo createFileInfo(String infoJsonPath) throws UnsupportedEncodingException {
        this.root = Paths.get(infoJsonPath, new String[0]).getParent().toString();
        byte[] buffer = FileUtil.File2byte(infoJsonPath);
        FileInfo info = (FileInfo)JSON.parseObject((String)new String(buffer, "utf-8"), FileInfo.class);
        return info;
    }

    private void checkMD5(FileInfo info) throws Exception {
        this.logger.debug("\u68c0\u67e5\u6587\u4ef6\u5febMD5");
        ArrayList<String> exceptions = new ArrayList<String>();
        for (SplitFilePart part : info.getPart()) {
            try {
                this.checkMD5(part);
            }
            catch (Exception e) {
                exceptions.add(e.getMessage());
            }
        }
        if (!exceptions.isEmpty()) {
            throw new Exception(String.join((CharSequence)";", exceptions));
        }
    }

    private String getAbsolutePath(String part) {
        if (this.root != null) {
            return this.root + File.separator + part;
        }
        return part;
    }

    private void checkMD5(SplitFilePart part) throws Exception {
        String filePart = this.getAbsolutePath(part.getFileName());
        this.logger.debug(UString.format("\u68c0\u67e5\u6587\u4ef6 {} md5", filePart));
        this.MD5.setFile(new File(filePart));
        String md5 = this.MD5.getMD5();
        if (!md5.equals(part.getMd5())) {
            throw new Exception(UString.format("\u6587\u4ef6\u5757 {} md5\u7801\u4e0d\u7b26", part.getFileName()));
        }
    }

    private FileChannel getReaderChannel(String partName) throws FileNotFoundException {
        if (partName == null) {
            return null;
        }
        String filePart = this.getAbsolutePath(partName);
        this.logger.debug(UString.format("\u8bfb\u53d6\u6587\u4ef6{}", partName));
        FileChannel channel = new RandomAccessFile(filePart, "r").getChannel();
        return channel;
    }

    private String getFilePartByIndex(int index) {
        Optional<SplitFilePart> optional = this.fileInfo.getPart().stream().filter(part -> part.getIndex() == index).findFirst();
        if (optional.isPresent()) {
            return optional.get().getFileName();
        }
        return null;
    }

    public synchronized int read(ByteBuffer buffer) throws Exception {
        if (this.partIndex >= this.partNum) {
            return 0;
        }
        if (this.offset >= this.size) {
            return 0;
        }
        if (this.currentReaderChannel == null) {
            this.currentReaderChannel = this.getReaderChannel(this.getFilePartByIndex(0));
        }
        return this._read(buffer);
    }

    private int _read(ByteBuffer buffer) throws IOException {
        long currentReaderChannelRemainingSize = this.currentReaderChannel.size() - this.currentReaderChannel.position();
        long bufferRemainingSize = buffer.remaining();
        if (bufferRemainingSize > currentReaderChannelRemainingSize) {
            this.currentReaderChannel.read(buffer);
            this.currentReaderChannel.close();
            ++this.partIndex;
            if (this.partIndex == this.partNum) {
                this.offset += currentReaderChannelRemainingSize;
                return 1;
            }
            this.currentReaderChannel = this.getReaderChannel(this.getFilePartByIndex(this.partIndex));
            return this._read(buffer);
        }
        int r = this.currentReaderChannel.read(buffer);
        this.offset += bufferRemainingSize;
        return r;
    }

    @Override
    public void close() throws IOException {
        if (this.currentReaderChannel != null) {
            this.currentReaderChannel.close();
        }
    }
}

