/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.util;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageUtil {
    private static final Logger log = LoggerFactory.getLogger(PackageUtil.class);
    protected static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    public static ClassLoader CLASS_LOADER;

    public static Set<Method> findClassAnnotationMethods(String scanPackages, Class<? extends Annotation> annotation) {
        Set<String> clazzSet = PackageUtil.findPackageClass(scanPackages);
        HashSet<Method> methods = new HashSet<Method>();
        for (String clazz : clazzSet) {
            try {
                Set<Method> ms = PackageUtil.findAnnotationMethods(clazz, annotation);
                if (ms == null) continue;
                methods.addAll(ms);
            }
            catch (Exception ignore) {}
        }
        return methods;
    }

    public static Set<Class<?>> findClassAnnotation(String scanPackages, Class<? extends Annotation> anno) throws ClassNotFoundException {
        Set<String> clazzSet = PackageUtil.findPackageClass(scanPackages);
        HashSet classSet = new HashSet();
        for (String clazz : clazzSet) {
            Class clasz = PackageUtil.loadClass(clazz);
            Annotation annotation = clasz.getAnnotation(anno);
            if (annotation == null) continue;
            classSet.add(clasz);
        }
        return classSet;
    }

    public static Set<Class<?>> findClassAnnotation(String[] scanPackages, Class<? extends Annotation> anno) throws ClassNotFoundException {
        HashSet<String> clazzSet = new HashSet<String>();
        for (String scanPackage : scanPackages) {
            clazzSet.addAll(PackageUtil.findPackageClass(scanPackage));
        }
        HashSet classSet = new HashSet();
        for (String clazz : clazzSet) {
            Class clasz = PackageUtil.loadClass(clazz);
            Annotation annotation = clasz.getAnnotation(anno);
            if (annotation == null) continue;
            classSet.add(clasz);
        }
        return classSet;
    }

    public static Set<Class<?>> findClassByInterface(String[] scanPackages, Class<?> interfaceClass) throws ClassNotFoundException {
        HashSet<String> clazzSet = new HashSet<String>();
        for (String scanPackage : scanPackages) {
            clazzSet.addAll(PackageUtil.findPackageClass(scanPackage));
        }
        HashSet classSet = new HashSet();
        for (String clazz : clazzSet) {
            Class clasz = PackageUtil.loadClass(clazz);
            if (!ArrayUtils.contains((Object[])clasz.getInterfaces(), interfaceClass)) continue;
            classSet.add(clasz);
        }
        return classSet;
    }

    public static Set<Class<?>> findClassByInterface(String scanPackages, Class<?> interfaceClass) throws ClassNotFoundException {
        Set<String> clazzSet = PackageUtil.findPackageClass(scanPackages);
        HashSet classSet = new HashSet();
        for (String clazz : clazzSet) {
            Class clasz = PackageUtil.loadClass(clazz);
            if (!ArrayUtils.contains((Object[])clasz.getInterfaces(), interfaceClass)) continue;
            classSet.add(clasz);
        }
        return classSet;
    }

    private static Class loadClass(String clazz) throws ClassNotFoundException {
        if (CLASS_LOADER == null) {
            return Class.forName(clazz);
        }
        return CLASS_LOADER.loadClass(clazz);
    }

    public static Set<String> findPackageClass(String scanPackages) {
        if (StringUtils.isBlank((CharSequence)scanPackages)) {
            return Collections.EMPTY_SET;
        }
        Set<String> packages = PackageUtil.checkPackage(scanPackages);
        HashSet<String> clazzSet = new HashSet<String>();
        for (String basePackage : packages) {
            if (StringUtils.isBlank((CharSequence)basePackage)) continue;
            try {
                Set<String> resourceNameSet = PackageUtil.getClassName(scanPackages, true);
                for (String resourceName : resourceNameSet) {
                    Class clasz = null;
                    try {
                        clasz = PackageUtil.loadClass(resourceName);
                    }
                    catch (Throwable e) {
                        continue;
                    }
                    if (clasz.isInterface()) continue;
                    clazzSet.add(resourceName);
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u5305\u4e0b\u9762\u7684\u7c7b\u4fe1\u606f\u5931\u8d25,package:" + basePackage, (Throwable)e);
            }
        }
        return clazzSet;
    }

    private static Set<String> checkPackage(String scanPackages) {
        if (StringUtils.isBlank((CharSequence)scanPackages)) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> packages = new HashSet<String>();
        Collections.addAll(packages, scanPackages.split(","));
        for (String pInArr : packages.toArray(new String[packages.size()])) {
            if (StringUtils.isBlank((CharSequence)pInArr) || pInArr.equals(".") || pInArr.startsWith(".")) continue;
            if (pInArr.endsWith(".")) {
                pInArr = pInArr.substring(0, pInArr.length() - 1);
            }
            Iterator packageIte = packages.iterator();
            boolean needAdd = true;
            while (packageIte.hasNext()) {
                String pack = (String)packageIte.next();
                if (pInArr.startsWith(pack + ".")) {
                    needAdd = false;
                    continue;
                }
                if (!pack.startsWith(pInArr + ".")) continue;
                packageIte.remove();
            }
            if (!needAdd) continue;
            packages.add(pInArr);
        }
        return packages;
    }

    public static Set<Method> findAnnotationMethods(String fullClassName, Class<? extends Annotation> anno) throws Exception {
        HashSet<Method> methodSet = new HashSet<Method>();
        Method[] methods = null;
        try {
            Class clz = PackageUtil.loadClass(fullClassName);
            methods = clz.getDeclaredMethods();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Method method : methods) {
            Annotation annotation;
            if (method.getModifiers() == 2 || method.getModifiers() == 4 || (annotation = method.getAnnotation(anno)) == null) continue;
            methodSet.add(method);
        }
        return methodSet;
    }

    public static Set<String> getClassName(String packageName, boolean childPackage) throws IOException {
        HashSet<String> fileNames = new HashSet<String>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String packagePath = packageName.replace(".", "/");
        Enumeration<URL> enumeration = loader.getResources(packagePath);
        while (enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            if (url != null) {
                String type = url.getProtocol();
                if (type.equals("file")) {
                    fileNames.addAll(PackageUtil.getClassNameByFile(url.getPath(), null, childPackage));
                    continue;
                }
                if (!type.equals("jar")) continue;
                fileNames.addAll(PackageUtil.getClassNameByJar(url.getPath(), childPackage));
                continue;
            }
            fileNames.addAll(PackageUtil.getClassNameByJars(((URLClassLoader)loader).getURLs(), packagePath, childPackage));
        }
        return fileNames;
    }

    private static List<String> getClassNameByFile(String filePath, List<String> className, boolean childPackage) {
        File[] childFiles;
        ArrayList<String> myClassName = new ArrayList<String>();
        File file = new File(filePath);
        for (File childFile : childFiles = file.listFiles()) {
            if (childFile.isDirectory()) {
                if (!childPackage) continue;
                myClassName.addAll(PackageUtil.getClassNameByFile(childFile.getPath(), myClassName, childPackage));
                continue;
            }
            String childFilePath = childFile.getPath();
            if (!childFilePath.endsWith(".class")) continue;
            childFilePath = childFilePath.substring(childFilePath.indexOf("\\classes") + 9, childFilePath.lastIndexOf("."));
            childFilePath = childFilePath.replace("\\", ".");
            myClassName.add(childFilePath);
        }
        return myClassName;
    }

    private static List<String> getClassNameByJar(String jarPath, boolean childPackage) {
        ArrayList<String> myClassName = new ArrayList<String>();
        String[] jarInfo = jarPath.split("!");
        String jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));
        String packagePath = jarInfo[1].substring(1);
        try {
            JarFile jarFile = new JarFile(jarFilePath);
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = entrys.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class")) continue;
                if (childPackage) {
                    if (!entryName.startsWith(packagePath)) continue;
                    entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                    myClassName.add(entryName);
                    continue;
                }
                int index = entryName.lastIndexOf("/");
                String myPackagePath = index != -1 ? entryName.substring(0, index) : entryName;
                if (!myPackagePath.equals(packagePath)) continue;
                entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                myClassName.add(entryName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myClassName;
    }

    private static List<String> getClassNameByJars(URL[] urls, String packagePath, boolean childPackage) {
        ArrayList<String> myClassName = new ArrayList<String>();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                String urlPath = url.getPath();
                if (urlPath.endsWith("classes/")) continue;
                String jarPath = urlPath + "!/" + packagePath;
                myClassName.addAll(PackageUtil.getClassNameByJar(jarPath, childPackage));
            }
        }
        return myClassName;
    }
}

