/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.util;

import java.util.function.ObjIntConsumer;

public class UString {
    public static String format(String s, Object ... args) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        int argsLength = args.length;
        StringBuilder sb = new StringBuilder(length * 3);
        int argsOffset = 0;
        for (int i = 0; i < length; ++i) {
            char currentChar = s.charAt(i);
            if (currentChar == '{' && i + 1 < length && s.charAt(i + 1) == '}') {
                if (argsOffset < argsLength) {
                    sb.append(args[argsOffset].toString());
                    ++argsOffset;
                }
                ++i;
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static void split(String str, String separatorChars, ObjIntConsumer<String> onSplit) {
        UString.splitWorker(str, separatorChars, -1, false, onSplit);
    }

    public static void splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens, ObjIntConsumer<String> onSplit) {
        if (str == null) {
            return;
        }
        int len = str.length();
        if (len == 0) {
            return;
        }
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        int index = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        onSplit.accept(str.substring(start, i), index);
                        ++index;
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        onSplit.accept(str.substring(start, i), index);
                        ++index;
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        onSplit.accept(str.substring(start, i), index);
                        ++index;
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            onSplit.accept(str.substring(start, i), index);
            ++index;
        }
    }

    public static void main(String[] args) {
        String a = "12085715    01030000208A110000010000000500000038964EC38E6D5E4020913B4E4CF53D40C82A1204896D5E40D00AC41343F53D40D0DE8DC3886D5E40A0644EEB44F53D40106A357A8E6D5E40B0F354664EF53D4038964EC38E6D5E4020913B4E4CF53D40  85d8680887684d2fa6449a8c095e5e5f    3103011500  1   16  \u670d\u52a1\u5e9320140429 20140720    U                   8.23955415485027E-4 1.28445193032717E-8     2019-04-02 12:26:20.000 0";
        UString.splitWorker(a, "    ", -1, false, (value, index) -> System.out.println((String)value));
    }
}

