/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.exception;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.vtile.commons.reflect.Bean;
import com.geoway.vtile.commons.util.UnsafeFuntion;
import java.util.ArrayList;
import java.util.List;

public class ExceptionToJSON {
    static final String EXCEPTION_CLASS_NAME = "exceptionCLassName";
    static final String EXCEPTION_VALUE = "exceptionValue";
    static final String EXCEPTION_STACK_TRACE = "stackTrace";
    static final String EXCEPTION_MESSAGE = "message";
    static final String EXCEPTION_LOCALIZED_MESSAGE = "localizedMessage";

    public static String toJSON(Throwable e) {
        String className = e.getClass().getName();
        JSONObject exception = (JSONObject)JSON.toJSON((Object)e);
        JSONObject returnObject = new JSONObject();
        returnObject.put(EXCEPTION_CLASS_NAME, (Object)className);
        returnObject.put(EXCEPTION_VALUE, (Object)exception);
        return returnObject.toJSONString();
    }

    public static <E extends Throwable> String toJSONArray(List<E> errors) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (Throwable throwable : errors) {
            stringList.add(ExceptionToJSON.toJSON(throwable));
        }
        return JSON.toJSONString(stringList);
    }

    public static <E extends Throwable> List<E> fromJSONArrAy(String exceptionArrStr) {
        JSONArray array = JSON.parseArray((String)exceptionArrStr);
        ArrayList<E> exceptionArr = new ArrayList<E>(array.size());
        for (Object str : array) {
            String exceptionStr = (String)str;
            E e = ExceptionToJSON.fromJSON(exceptionStr);
            exceptionArr.add(e);
        }
        return exceptionArr;
    }

    private static StackTraceElement[] getStackTraceElementFromJson(JSONArray jsonArray) {
        StackTraceElement[] array = new StackTraceElement[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            StackTraceElement stackTraceElement;
            JSONObject object = jsonArray.getJSONObject(i);
            String fileName = object.getString("fileName");
            int lineNumber = object.getIntValue("lineNumber");
            String methodName = object.getString("methodName");
            String className = object.getString("className");
            array[i] = stackTraceElement = new StackTraceElement(className, methodName, fileName, lineNumber);
        }
        return array;
    }

    public static <E extends Throwable> E fromJSON(String exceptionStr) {
        JSONObject exception = (JSONObject)JSON.parse((String)exceptionStr);
        String className = exception.getString(EXCEPTION_CLASS_NAME);
        JSONObject exceptionValue = exception.getJSONObject(EXCEPTION_VALUE);
        JSONArray jsonStackTraceElementArray = exceptionValue.getJSONArray(EXCEPTION_STACK_TRACE);
        StackTraceElement[] stackTraceElement = ExceptionToJSON.getStackTraceElementFromJson(jsonStackTraceElementArray);
        String message = exceptionValue.getString(EXCEPTION_MESSAGE);
        Class exceptionClass = Throwable.class;
        Throwable exceptionObj = null;
        if (className != null) {
            try {
                exceptionClass = Bean.getClassByName(className);
                if (!Bean.isExtends(exceptionClass, Throwable.class).booleanValue()) {
                    exceptionClass = Throwable.class;
                }
                exceptionObj = UnsafeFuntion.get().createInstance(exceptionClass);
                Bean.setSingleObjectValueByPrivateFieldName(exceptionObj, "detailMessage", message);
                Bean.setSingleObjectValueByPrivateFieldName(exceptionObj, EXCEPTION_STACK_TRACE, stackTraceElement);
            }
            catch (ClassNotFoundException e) {
                exceptionClass = Throwable.class;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return (E)exceptionObj;
    }
}

