/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.spatial.geofeature;

import com.geoway.vtile.commons.util.DoubleBuilder;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;

public class GeoPart {
    protected DoubleBuilder doubleBuilder;
    protected RING_TYPE ringType = null;
    protected double minX;
    protected double minY;
    protected double maxX;
    protected double maxY;
    protected GeoBuffer geoBuffer;
    protected double minZ = Double.NaN;
    protected double maxZ = Double.NaN;

    public double[] getBBOX() {
        return new double[]{this.minX, this.minY, this.maxX, this.maxY};
    }

    public double[] zInterval() {
        return new double[]{this.minZ, this.maxZ};
    }

    public void setZInterval(double minZ, double maxZ) {
        this.minZ = minZ;
        this.maxZ = maxZ;
    }

    public int getCoordinateCount() {
        return this.doubleBuilder.size() / this.getDimension();
    }

    public GeoPart(DoubleBuilder doubleBuilder, GeoBuffer geoBuffer) {
        this.doubleBuilder = doubleBuilder;
        this.minX = doubleBuilder.get(0);
        this.minY = doubleBuilder.get(1);
        this.maxX = doubleBuilder.get(0);
        this.maxY = doubleBuilder.get(1);
        this.geoBuffer = geoBuffer;
    }

    GeoPart(DoubleBuilder doubleBuilder, double minX, double minY, double maxX, double maxY, GeoBuffer geoBuffer) {
        this(doubleBuilder, minX, minY, maxX, maxY, geoBuffer, null);
    }

    GeoPart(DoubleBuilder doubleBuilder, double minX, double minY, double maxX, double maxY, GeoBuffer geoBuffer, RING_TYPE ringType) {
        this.doubleBuilder = doubleBuilder;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.geoBuffer = geoBuffer;
        this.ringType = ringType;
    }

    public RING_TYPE getRingType() {
        return this.ringType;
    }

    public void setRingType(RING_TYPE ringType) {
        this.ringType = ringType;
    }

    public Integer getDimension() {
        return this.geoBuffer.dimension;
    }

    public Integer getSRID() {
        return this.geoBuffer.srid;
    }

    public Constants.GEO_TYPE getGeoType() {
        return this.geoBuffer.geoType;
    }

    public DoubleBuilder getDoubleBuilder() {
        return this.doubleBuilder;
    }

    public void setDoubleBuilder(DoubleBuilder doubleBuilder) {
        this.doubleBuilder = doubleBuilder;
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    public GeoBuffer getGeoBuffer() {
        return this.geoBuffer;
    }

    public void setGeoBuffer(GeoBuffer geoBuffer) {
        this.geoBuffer = geoBuffer;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public void setMinZ(double minZ) {
        this.minZ = minZ;
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public void setMaxZ(double maxZ) {
        this.maxZ = maxZ;
    }

    public static enum RING_TYPE {
        outside,
        inside;

    }
}

