/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.spatial.shape;

import com.geoway.vtile.commons.util.BuilderCreator;
import com.geoway.vtile.commons.util.DoubleBuilder;
import com.geoway.vtile.commons.util.FileUtil;
import com.geoway.vtile.spatial.AGeomDecoder;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.GeomDecoder;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.spatial.geofeature.GeoPart;
import com.geoway.vtile.spatial.shape.ShapeEncoder;
import com.geoway.vtile.spatial.shape.ShapeType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

@AGeomDecoder(type=Constants.SPATIAL_TYPE.shape)
public class ShapeDecoder
implements GeomDecoder<byte[]> {
    public static final ShapeDecoder DECODER = new ShapeDecoder();

    public static Constants.GEO_TYPE is(ShapeType type) {
        if (type.isPointType()) {
            return Constants.GEO_TYPE.POINT;
        }
        if (type.isLineType()) {
            return Constants.GEO_TYPE.MULTILINESTRING;
        }
        if (type.isPolygonType()) {
            return Constants.GEO_TYPE.MULTIPOLYGON;
        }
        if (type.isMultiPointType()) {
            return Constants.GEO_TYPE.MULTIPOINT;
        }
        throw new RuntimeException("\u672a\u77e5\u7684\u6570\u636e\u7c7b\u578b" + type.toString());
    }

    @Override
    public GeoBuffer toGeoBuffer(byte[] bytes) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        return this.toGeoBuffer(byteBuffer);
    }

    @Override
    public GeoBuffer toGeoBuffer(ByteBuffer buffer) throws IOException {
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        ShapeType recordType = ShapeType.forID(buffer.getInt());
        double minX = Double.NaN;
        double minY = Double.NaN;
        double maxX = Double.NaN;
        double maxY = Double.NaN;
        if (recordType.isLineType() || recordType.isPolygonType()) {
            minX = buffer.getDouble();
            minY = buffer.getDouble();
            maxX = buffer.getDouble();
            maxY = buffer.getDouble();
        }
        Constants.GEO_TYPE geoType = ShapeDecoder.is(recordType);
        int inputDimension = recordType.isHasZ() ? 3 : 2;
        GeoBuffer geo = new GeoBuffer(geoType, 0, inputDimension);
        geo = this.process(geoType, buffer, geo, recordType.isHasZ(), false);
        geo.setBBOX(minX, minY, maxX, maxY);
        return geo;
    }

    protected GeoBuffer process(Constants.GEO_TYPE geoType, ByteBuffer buffer, GeoBuffer geo, boolean hasZ, boolean hasM) throws IOException {
        switch (geoType) {
            case POINT: {
                this.processPoint(buffer, geo, hasZ, hasM);
                break;
            }
            case MULTILINESTRING: {
                this.processMultiLine(buffer, geo, hasZ, hasM);
                break;
            }
            case MULTIPOLYGON: {
                this.processMultiPolygon(buffer, geo, hasZ, hasM);
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u51e0\u4f55\u7c7b\u578b\uff1a" + geoType.name());
            }
        }
        geo.trimToSize();
        return geo;
    }

    private void processMultiPolygon(ByteBuffer buffer, GeoBuffer geo, boolean hasZ, boolean hasM) {
        int finish;
        int part;
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        int start = 0;
        int length = 0;
        int dimension = hasZ ? 3 : 2;
        DoubleBuffer doubleBuffer = buffer.asDoubleBuffer();
        for (part = 0; part < numParts; ++part) {
            start = partOffsets[part];
            finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            length = finish - start;
            double[] xy = new double[length * 2];
            doubleBuffer.get(xy);
            double minX = xy[0];
            double minY = xy[1];
            double maxX = xy[0];
            double maxY = xy[1];
            DoubleBuilder doubleBuilder = BuilderCreator.createDouble((length + 1) * dimension);
            for (int i = 0; i < length; ++i) {
                double x = xy[i * 2];
                double y = xy[i * 2 + 1];
                if (x > maxX) {
                    maxX = x;
                }
                if (x < minX) {
                    minX = x;
                }
                if (y > maxY) {
                    maxY = y;
                }
                if (y < minY) {
                    minY = y;
                }
                doubleBuilder.append(x);
                doubleBuilder.append(y);
                if (!hasZ) continue;
                doubleBuilder.append(0.0);
            }
            if (dimension == 2) {
                boolean isclose = false;
                if (doubleBuilder.get(0) == doubleBuilder.get((length - 1) * dimension) && doubleBuilder.get(1) == doubleBuilder.get((length - 1) * dimension + 1)) {
                    isclose = true;
                }
                if (!isclose) {
                    doubleBuilder.append(doubleBuilder.get(0));
                    doubleBuilder.append(doubleBuilder.get(1));
                }
            }
            GeoPart.RING_TYPE ringType = this.getRingType(doubleBuilder, dimension);
            geo.addPolygonPart(doubleBuilder, minX, minY, maxX, maxY, ringType);
        }
        if (hasZ) {
            doubleBuffer.position(doubleBuffer.position() + 2);
            for (part = 0; part < numParts; ++part) {
                start = partOffsets[part];
                DoubleBuilder doubleBuilder = geo.getData(part);
                double minZ = Double.NaN;
                double maxZ = Double.NaN;
                GeoPart geoPart = geo.getPart(part);
                finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
                length = finish - start;
                double[] z = new double[length];
                doubleBuffer.get(z);
                for (int i = 0; i < length; ++i) {
                    double value = z[i];
                    doubleBuilder.set(i * 3 + 2, value);
                    if (minZ == Double.NaN) {
                        minZ = maxZ = value;
                        continue;
                    }
                    if (value < minZ) {
                        minZ = value;
                    }
                    if (!(value > maxZ)) continue;
                    maxZ = value;
                }
                geoPart.setZInterval(minZ, maxZ);
                boolean isclose = false;
                if (doubleBuilder.get(0) == doubleBuilder.get((length - 1) * dimension) && doubleBuilder.get(1) == doubleBuilder.get((length - 1) * dimension + 1) && doubleBuilder.get(2) == doubleBuilder.get((length - 1) * dimension + 2)) {
                    isclose = true;
                }
                if (isclose) continue;
                doubleBuilder.append(doubleBuilder.get(0));
                doubleBuilder.append(doubleBuilder.get(1));
                doubleBuilder.append(doubleBuilder.get(2));
            }
        }
        geo.tryMultiToSingle();
    }

    protected GeoPart.RING_TYPE getRingType(DoubleBuilder doubleBuilder, int dimension) {
        if (GeoBuffer.isCCW(doubleBuilder, dimension)) {
            return GeoPart.RING_TYPE.inside;
        }
        return GeoPart.RING_TYPE.outside;
    }

    private void processMultiLine(ByteBuffer buffer, GeoBuffer geo, boolean hasZ, boolean hasM) {
        int finish;
        int part;
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        int start = 0;
        int length = 0;
        boolean clonePoint = false;
        DoubleBuffer doubleBuffer = buffer.asDoubleBuffer();
        int dimension = hasZ ? 3 : 2;
        for (part = 0; part < numParts; ++part) {
            start = partOffsets[part];
            finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            int xyLength = length = finish - start;
            if (length == 1) {
                length = 2;
                clonePoint = true;
            } else {
                clonePoint = false;
            }
            double[] xy = new double[xyLength * 2];
            doubleBuffer.get(xy);
            double minX = xy[0];
            double minY = xy[1];
            double maxX = xy[0];
            double maxY = xy[1];
            DoubleBuilder doubleBuilder = BuilderCreator.createDouble((xyLength + 1) * dimension);
            for (int i = 0; i < xyLength; ++i) {
                double x = xy[i * 2];
                double y = xy[i * 2 + 1];
                if (x > maxX) {
                    maxX = x;
                }
                if (x < minX) {
                    minX = x;
                }
                if (y > maxY) {
                    maxY = y;
                }
                if (y < minY) {
                    minY = y;
                }
                doubleBuilder.append(x);
                doubleBuilder.append(y);
                if (!hasZ) continue;
                doubleBuilder.append(0.0);
            }
            if (clonePoint) {
                doubleBuilder.append(doubleBuilder.get(0));
                doubleBuilder.append(doubleBuilder.get(1));
                if (hasZ) {
                    doubleBuilder.append(0.0);
                }
            }
            geo.addLinePart(doubleBuilder, minX, minY, maxX, maxY);
        }
        if (hasZ) {
            doubleBuffer.position(doubleBuffer.position() + 2);
            for (part = 0; part < numParts; ++part) {
                start = partOffsets[part];
                double minZ = Double.NaN;
                double maxZ = Double.NaN;
                GeoPart geoPart = geo.getPart(part);
                DoubleBuilder doubleBuilder = geo.getData(part);
                finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
                length = finish - start;
                if (length == 1) {
                    length = 2;
                    clonePoint = true;
                } else {
                    clonePoint = false;
                }
                double[] z = new double[length];
                doubleBuffer.get(z);
                for (int i = 0; i < length; ++i) {
                    double value = z[i];
                    doubleBuilder.set(i * 3 + 2, value);
                    if (minZ == Double.NaN) {
                        minZ = maxZ = value;
                        continue;
                    }
                    if (value < minZ) {
                        minZ = value;
                    }
                    if (!(value > maxZ)) continue;
                    maxZ = value;
                }
                geoPart.setZInterval(minZ, maxZ);
            }
        }
        geo.tryMultiToSingle();
    }

    private void processPoint(ByteBuffer buffer, GeoBuffer geo, boolean hasZ, boolean hasM) {
        int dimension = hasZ ? 3 : 2;
        double x = buffer.getDouble();
        double y = buffer.getDouble();
        double z = Double.NaN;
        if (hasZ) {
            z = buffer.getDouble();
        }
        if (hasM) {
            buffer.getDouble();
        }
        geo.addPoint(x, y, z);
    }

    public static void main(String[] aaa) throws IOException {
        byte[] aaaa = FileUtil.File2byte("c://tmp//shape");
        ByteBuffer b = ByteBuffer.wrap(aaaa);
        GeoBuffer buffer = DECODER.toGeoBuffer(b);
        ShapeEncoder shapeEncoder = new ShapeEncoder();
        byte[] bytes1 = shapeEncoder.fromGeoBuffer(buffer);
        ByteBuffer bb = ByteBuffer.wrap(bytes1);
        GeoBuffer buffer1 = DECODER.toGeoBuffer(bb);
        FileUtil.byte2File(bytes1, "c://tmp//shape1");
    }
}

