/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.spatial;

import com.alibaba.fastjson.util.Base64;
import com.geoway.vtile.commons.util.PackageUtil;
import com.geoway.vtile.spatial.AGeomDecoder;
import com.geoway.vtile.spatial.AGeomEncoder;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.GeomDecoder;
import com.geoway.vtile.spatial.GeomEncoder;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;

public class Geom {
    static final Map<Constants.SPATIAL_TYPE, GeomDecoder<Object>> DECODER_MAP;
    static final Map<Constants.SPATIAL_TYPE, GeomEncoder<Object>> ENCODER_MAP;
    Constants.SPATIAL_TYPE type;
    Object originGeom;
    int srid = 0;

    public Constants.SPATIAL_TYPE getType() {
        return this.type;
    }

    public Object getOriginGeom() {
        return this.originGeom;
    }

    public Geom(Constants.SPATIAL_TYPE type, Object originGeom) {
        this.originGeom = originGeom;
        this.type = type;
    }

    public void setSRID(int srid) {
        this.srid = srid;
    }

    public String toWkt() {
        return this.toGeoBuffer().toWkt();
    }

    public String toString() {
        return this.toGeoBuffer().toJTSGeometry().toString();
    }

    public Geometry toJTSGeometry() {
        return this.toGeoBuffer().toJTSGeometry();
    }

    public GeoBuffer toGeoBuffer() {
        try {
            GeomDecoder<Object> decoder = DECODER_MAP.get((Object)this.type);
            if (decoder == null) {
                throw new RuntimeException("\u8f6c\u6362\u5668\u4e0d\u652f\u6301\u7a7a\u95f4\u7c7b\u578b:" + this.type.name());
            }
            GeoBuffer geoBuffer = decoder.toGeoBuffer(this.originGeom);
            return geoBuffer;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void changeType(Constants.SPATIAL_TYPE type) {
        if (type == this.type) {
            return;
        }
        GeoBuffer geoBuffer = this.toGeoBuffer();
        geoBuffer.setSRID(this.srid);
        GeomEncoder<Object> encoder = ENCODER_MAP.get((Object)type);
        if (encoder == null) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u8f6c\u6362\u5230\u7a7a\u95f4\u7c7b\u578b" + type.name());
        }
        this.originGeom = encoder.fromGeoBuffer(geoBuffer);
        this.type = type;
    }

    public static void main(String[] aaaa) {
        String aaa = "0106000020021200000300000001030000000100000006000000088CFF2DB6875C40286C98F7A6694140D043FAC4AA875C40981EDECFA5694140A80CE3ADA1875C40E01B7349066A4140E8E9D6DCAA875C40280CAD49066A4140709EABADB6875C4058A48604A7694140088CFF2DB6875C40286C98F7A669414001030000000100000008000000F82245CC5A875C40C0896DA39D694140606E0D1847875C40704131C79A69414050B4CB2A47875C40E0FF5A949E694140082969645A875C4098067250B8694140A84F1F1962875C4020B72B53BB6941406087D59770875C40F80DAB1DBB694140F0E61E676E875C403044FDBA9F694140F82245CC5A875C40C0896DA39D69414001030000000100000007000000487BD2E5FE875C4058290FE79B69414040A233CEFE875C40F01BC29A8F694140B8052059F8875C40689F210190694140F09F9041F8875C40500062D0916941402833000000885C40883C9768B36941402833000000885C4080372D179E694140487BD2E5FE875C4058290FE79B694140";
        System.out.println(aaa.length());
        byte[] c = Base64.decodeFast((String)aaa);
        System.out.println(c.length);
    }

    static {
        Set<Class<?>> clazzSetEncoder;
        Set<Class<?>> clazzSetDecoder;
        HashMap _DECODER_MAP = new HashMap();
        HashMap _ENCODER_MAP = new HashMap();
        try {
            clazzSetDecoder = PackageUtil.findClassAnnotation("com.geoway.vtile.spatial", AGeomDecoder.class);
            clazzSetEncoder = PackageUtil.findClassAnnotation("com.geoway.vtile.spatial", AGeomEncoder.class);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("\u52a0\u8f7dITableBuilderMap\u5931\u8d25," + e.getMessage());
        }
        clazzSetDecoder.forEach(clazz -> {
            AGeomDecoder annotation = clazz.getAnnotation(AGeomDecoder.class);
            Constants.SPATIAL_TYPE type = annotation.type();
            Class cla = clazz;
            try {
                _DECODER_MAP.put(type, cla.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
        clazzSetEncoder.forEach(clazz -> {
            AGeomEncoder annotation = clazz.getAnnotation(AGeomEncoder.class);
            Constants.SPATIAL_TYPE type = annotation.type();
            Class cla = clazz;
            try {
                _ENCODER_MAP.put(type, cla.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
        DECODER_MAP = Collections.unmodifiableMap(_DECODER_MAP);
        ENCODER_MAP = Collections.unmodifiableMap(_ENCODER_MAP);
    }
}

