/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.spatial.tool;

public class SimpleGISTool {
    public static double[] LINEINTERSECTS(double line1StartX, double line1StartY, double line1EndX, double line1EndY, double line2StartX, double line2StartY, double line2EndX, double line2EndY) {
        if (line1StartX == line2StartX && line1StartY == line2StartY || line1StartX == line2EndX && line1StartY == line2EndY) {
            return new double[]{line1StartX, line1StartY};
        }
        if (line1EndX == line2StartX && line1EndY == line2StartY || line1EndX == line2EndX && line1EndY == line2EndY) {
            return new double[]{line1EndX, line1EndY};
        }
        double[] res = new double[]{Double.MAX_VALUE, Double.MAX_VALUE};
        double denominator = (line2EndY - line2StartY) * (line1EndX - line1StartX) - (line2EndX - line2StartX) * (line1EndY - line1StartY);
        if (denominator == 0.0) {
            if (res[0] != Double.MAX_VALUE && res[1] != Double.MAX_VALUE) {
                return res;
            }
            return null;
        }
        double a = line1StartY - line2StartY;
        double b = line1StartX - line2StartX;
        double numerator1 = (line2EndX - line2StartX) * a - (line2EndY - line2StartY) * b;
        double numerator2 = (line1EndX - line1StartX) * a - (line1EndY - line1StartY) * b;
        a = numerator1 / denominator;
        b = numerator2 / denominator;
        if (b >= 0.0 && b <= 1.0) {
            res[0] = line1StartX + a * (line1EndX - line1StartX);
            res[1] = line1StartY + a * (line1EndY - line1StartY);
            return res;
        }
        return null;
    }

    public static boolean pointInPolygon(double px, double py, double[][] poly) {
        boolean flag = false;
        for (int polyIndex = 0; polyIndex < poly.length; ++polyIndex) {
            double[] subpoly = poly[polyIndex];
            int length = subpoly.length / 2;
            int i = 0;
            int l = length;
            int j = l - 1;
            while (i < l) {
                double sx = subpoly[2 * i];
                double sy = subpoly[2 * i + 1];
                double tx = subpoly[2 * j];
                double ty = subpoly[2 * j + 1];
                if (sx == px && sy == py || tx == px && ty == py) {
                    return true;
                }
                if (sy < py && ty >= py || sy >= py && ty < py) {
                    double x = sx + (py - sy) * (tx - sx) / (ty - sy);
                    if (x == px) {
                        return true;
                    }
                    if (x > px) {
                        flag = !flag;
                    }
                }
                j = i++;
            }
        }
        return flag;
    }

    public static boolean polyWithin(double[] polyOut, double[] polyIn) {
        int lengthOut = polyOut.length / 2;
        int lengthIn = polyIn.length / 2;
        for (int i = 0; i < lengthOut; ++i) {
            double bY;
            double bX;
            double aY;
            double aX;
            if (i != lengthOut - 1) {
                aX = polyOut[i * 2];
                aY = polyOut[i * 2 + 1];
                bX = polyOut[i * 2 + 2];
                bY = polyOut[i * 2 + 3];
            } else {
                aX = polyOut[i * 2];
                aY = polyOut[i * 2 + 1];
                bX = polyOut[0];
                bY = polyOut[1];
            }
            for (int j = 0; j < lengthIn; ++j) {
                double dY;
                double dX;
                double cY;
                double cX;
                if (j != lengthIn - 1) {
                    cX = polyIn[j * 2];
                    cY = polyIn[j * 2 + 1];
                    dX = polyIn[j * 2 + 2];
                    dY = polyIn[j * 2 + 3];
                } else {
                    cX = polyIn[j * 2];
                    cY = polyIn[j * 2 + 1];
                    dX = polyIn[0];
                    dY = polyIn[1];
                }
                if (SimpleGISTool.LINEINTERSECTS(aX, aY, bX, bY, cX, cY, dX, dY) == null) continue;
                return false;
            }
        }
        double firstX = polyIn[0];
        double firstY = polyIn[1];
        return SimpleGISTool.pointInPolygon(firstX, firstY, new double[][]{polyOut});
    }

    public static double length(double x0, double y0, double x1, double y1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        double len = StrictMath.sqrt(dx * dx + dy * dy);
        return len;
    }

    public static double[] bboxIntersect(double[] bbox1, double[] bbox2) {
        double geoLeftX = bbox1[0] < bbox2[0] ? bbox2[0] : bbox1[0];
        double geoBottomY = bbox1[1] < bbox2[1] ? bbox2[1] : bbox1[1];
        double geoRightX = bbox1[2] > bbox2[2] ? bbox2[2] : bbox1[2];
        double geoTopY = bbox1[3] > bbox2[3] ? bbox2[3] : bbox1[3];
        return new double[]{geoLeftX, geoBottomY, geoRightX, geoTopY};
    }

    public static boolean isRectangle(double[] leftTop, double[] rightTop, double[] rightBottom, double[] leftBottom) {
        if (leftTop[0] != leftBottom[0]) {
            return false;
        }
        if (leftTop[1] != rightTop[1]) {
            return false;
        }
        if (rightTop[0] != rightBottom[0]) {
            return false;
        }
        return rightBottom[1] == leftBottom[1];
    }
}

