/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.spatial.wkb;

import com.geoway.vtile.commons.util.BuilderCreator;
import com.geoway.vtile.commons.util.DoubleBuilder;
import com.geoway.vtile.spatial.ByteOrderDataInStream;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.GeometryInfo;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.spatial.geofeature.GeoPart;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public abstract class AbstractWkbDecoder {
    public static final int UNKNOWN = 0;
    public static final int POINT = 1;
    public static final int LINESTRING = 2;
    public static final int POLYGON = 3;
    public static final int MULTIPOINT = 4;
    public static final int MULTILINESTRING = 5;
    public static final int MULTIPOLYGON = 6;
    public static final int COLLECTION = 7;

    int getSRID(ByteOrderDataInStream dis) throws IOException {
        byte[] sridByte = dis.readByte4();
        int srid = 0;
        srid = sridByte[3] << 24 | (sridByte[2] & 0xFF) << 16 | (sridByte[1] & 0xFF) << 8 | sridByte[0] & 0xFF;
        return srid;
    }

    ByteOrderDataInStream getStruct(ByteArrayInputStream instream) {
        ByteOrderDataInStream dis = new ByteOrderDataInStream(instream);
        return dis;
    }

    void setByteOrder(ByteOrderDataInStream dis) throws IOException {
        byte byteOrderWKB = dis.readByte();
        int byteOrder = byteOrderWKB == 1 ? 2 : 1;
        dis.setOrder(byteOrder);
    }

    GeometryInfo buildGeometryTypeAndZM(ByteOrderDataInStream dis) throws IOException {
        int typeInt = dis.readInt();
        GeometryInfo info = new GeometryInfo();
        info.geometryType = typeInt & 0xFF;
        info.hasZ = (typeInt & Integer.MIN_VALUE) != 0;
        info.hasM = (typeInt & 0x40000000) != 0;
        return info;
    }

    void check(ByteArrayInputStream instream) throws Exception {
        if (null == instream || instream.available() <= 0) {
            throw new Exception("\u6d41\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    int getSize(ByteArrayInputStream instream) {
        return instream.available();
    }

    protected GeoBuffer _toGeoBuffer(byte[] bytes) throws Exception {
        ByteArrayInputStream instream = new ByteArrayInputStream(bytes);
        ByteOrderDataInStream dis = new ByteOrderDataInStream(instream);
        byte byteOrderWKB = dis.readByte();
        int byteOrder = byteOrderWKB == 1 ? 2 : 1;
        dis.setOrder(byteOrder);
        int typeInt = dis.readInt();
        GeometryInfo info = new GeometryInfo();
        info.geometryType = (typeInt & 0xFFFF) % 1000;
        info.hasZ = (typeInt & Integer.MIN_VALUE) != 0 || (typeInt & 0xFFFF) / 1000 == 1 || (typeInt & 0xFFFF) / 1000 == 3;
        info.hasM = (typeInt & 0x40000000) != 0 || (typeInt & 0xFFFF) / 1000 == 2 || (typeInt & 0xFFFF) / 1000 == 3;
        boolean haveSrid = (typeInt & 0x20000000) != 0;
        int srid = 0;
        if (haveSrid) {
            srid = dis.readInt();
        }
        Constants.GEO_TYPE geoType = this.is(info.geometryType);
        int inputDimension = info.hasZ ? 3 : 2;
        inputDimension = 2;
        GeoBuffer geo = new GeoBuffer(geoType, srid, inputDimension);
        return this.process(geoType, dis, geo, info);
    }

    protected GeoBuffer process(Constants.GEO_TYPE geoType, ByteOrderDataInStream dis, GeoBuffer geo, GeometryInfo info) throws IOException {
        switch (geoType) {
            case POINT: {
                this.processPoint(dis, geo, info);
                break;
            }
            case LINESTRING: {
                this.processLineString(dis, geo, info);
                break;
            }
            case POLYGON: {
                this.processPolygon(dis, geo, info);
                break;
            }
            case MULTIPOINT: {
                this.processMultiPoint(dis, geo, info);
                break;
            }
            case MULTILINESTRING: {
                this.processMultiLine(dis, geo, info);
                break;
            }
            case MULTIPOLYGON: {
                this.processMultiPolygon(dis, geo, info);
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u51e0\u4f55\u7c7b\u578b\uff1a" + geoType.name());
            }
        }
        return geo;
    }

    public Constants.GEO_TYPE is(int type) {
        switch (type) {
            case 1: {
                return Constants.GEO_TYPE.POINT;
            }
            case 2: {
                return Constants.GEO_TYPE.LINESTRING;
            }
            case 3: {
                return Constants.GEO_TYPE.POLYGON;
            }
            case 7: {
                return Constants.GEO_TYPE.COLLECTION;
            }
            case 4: {
                return Constants.GEO_TYPE.MULTIPOINT;
            }
            case 5: {
                return Constants.GEO_TYPE.MULTILINESTRING;
            }
            case 6: {
                return Constants.GEO_TYPE.MULTIPOLYGON;
            }
        }
        String detailMsg = "";
        if (10 == type) {
            detailMsg = "\uff0c\u5efa\u8bae\u68c0\u67e5\u51e0\u4f55\u5b57\u6bb5\u7c7b\u578b SELECT distinct st_geometrytype(shape) from xxx \uff0c\u67e5\u770b\u662f\u5426\u542b\u6709\u4e0d\u652f\u6301\u7684\u66f2\u9762\u6570\u636e\uff08CurvePolygon\uff09";
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684WKB\u51e0\u4f55\u7c7b\u578b" + type + detailMsg);
    }

    private void processMultiPolygon(ByteOrderDataInStream dis, GeoBuffer geo, GeometryInfo info) throws IOException {
        int nParts = dis.readInt();
        for (int i = 0; i < nParts; ++i) {
            boolean haveSrid;
            byte byteOrderWKB = dis.readByte();
            int byteOrder = byteOrderWKB == 1 ? 2 : 1;
            dis.setOrder(byteOrder);
            int typeInt = dis.readInt();
            boolean bl = haveSrid = (typeInt & 0x20000000) != 0;
            if (haveSrid) {
                dis.readInt();
            }
            this.processPolygon(dis, geo, info);
        }
    }

    private void processMultiLine(ByteOrderDataInStream dis, GeoBuffer geo, GeometryInfo info) throws IOException {
        int nParts = dis.readInt();
        for (int i = 0; i < nParts; ++i) {
            boolean haveSrid;
            byte byteOrderWKB = dis.readByte();
            int byteOrder = byteOrderWKB == 1 ? 2 : 1;
            dis.setOrder(byteOrder);
            int typeInt = dis.readInt();
            boolean bl = haveSrid = (typeInt & 0x20000000) != 0;
            if (haveSrid) {
                dis.readInt();
            }
            DoubleBuilder doubleBuilder = null;
            int count = dis.readInt();
            int doubleBufferSize = info.hasZ ? count * 3 : count * 2;
            doubleBuilder = BuilderCreator.createDouble(doubleBufferSize);
            double[] bbox = this.readPointArray(dis, doubleBuilder, info, count);
            geo.addLinePart(doubleBuilder, bbox[0], bbox[1], bbox[2], bbox[3]);
        }
    }

    private void processMultiPoint(ByteOrderDataInStream dis, GeoBuffer geo, GeometryInfo info) throws IOException {
        int nParts = dis.readInt();
        for (int i = 0; i < nParts; ++i) {
            boolean haveSrid;
            byte byteOrderWKB = dis.readByte();
            int byteOrder = byteOrderWKB == 1 ? 2 : 1;
            dis.setOrder(byteOrder);
            int typeInt = dis.readInt();
            boolean bl = haveSrid = (typeInt & 0x20000000) != 0;
            if (haveSrid) {
                dis.readInt();
            }
            this.processPoint(dis, geo, info);
        }
    }

    private void processPolygon(ByteOrderDataInStream dis, GeoBuffer geo, GeometryInfo info) throws IOException {
        int nParts = dis.readInt();
        for (int i = 0; i < nParts; ++i) {
            DoubleBuilder doubleBuilder = null;
            int count = dis.readInt();
            int doubleBufferSize = count * 2;
            doubleBuilder = BuilderCreator.createDouble(doubleBufferSize);
            double[] bbox = this.readPointArray(dis, doubleBuilder, info, count);
            if (i == 0) {
                geo.addPolygonPart(doubleBuilder, bbox[0], bbox[1], bbox[2], bbox[3], GeoPart.RING_TYPE.outside);
                continue;
            }
            geo.addPolygonPart(doubleBuilder, bbox[0], bbox[1], bbox[2], bbox[3], GeoPart.RING_TYPE.inside);
        }
    }

    private void processLineString(ByteOrderDataInStream dis, GeoBuffer geo, GeometryInfo info) throws IOException {
        DoubleBuilder doubleBuilder = null;
        int count = dis.readInt();
        int doubleBufferSize = info.hasZ ? count * 3 : count * 2;
        doubleBuilder = BuilderCreator.createDouble(doubleBufferSize);
        double[] bbox = this.readPointArray(dis, doubleBuilder, info, count);
        geo.addLinePart(doubleBuilder, bbox[0], bbox[1], bbox[2], bbox[3]);
    }

    private void processPoint(ByteOrderDataInStream dis, GeoBuffer geo, GeometryInfo info) throws IOException {
        double x = dis.readDouble();
        double y = dis.readDouble();
        double z = Double.NaN;
        if (info.hasZ) {
            z = dis.readDouble();
        }
        if (info.hasM) {
            dis.readDouble();
        }
        geo.addPoint(x, y, z);
    }

    private double[] readPointArray(ByteOrderDataInStream dis, DoubleBuilder doubleBuilder, GeometryInfo info, int length) throws IOException {
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        for (int i = 0; i < length; ++i) {
            double d;
            double x = dis.readDouble();
            double y = dis.readDouble();
            if (i == 0) {
                minX = maxX = x;
                minY = maxY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (x < minX) {
                minX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (y < minY) {
                minY = y;
            }
            doubleBuilder.append(x);
            doubleBuilder.append(y);
            if (info.hasZ) {
                d = dis.readDouble();
            }
            if (!info.hasM) continue;
            d = dis.readDouble();
        }
        return new double[]{minX, minY, maxX, maxY};
    }
}

