/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.pipeline;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicReference;

public class MiGzUtil {
    public static final byte[] GZIP_HEADER = new byte[]{31, -117, 8, 4, 0, 0, 0, 0, 2, 0, 8, 0, 77, 90, 4, 0};
    public static final int GZIP_HEADER_SIZE = GZIP_HEADER.length + 4;
    public static final int GZIP_FOOTER_SIZE = 8;
    public static final int DEFAULT_BLOCK_SIZE = 524288;

    private MiGzUtil() {
    }

    public static int maxCompressedSize(int uncompressed) {
        int deflateBlockSize = 127;
        return uncompressed + (uncompressed + 127 - 1) / 127 * 5 + 1;
    }

    public static void checkException(AtomicReference<RuntimeException> exception) throws IOException {
        if (exception.get() != null) {
            RuntimeException re = exception.get();
            if (re instanceof UncheckedIOException) {
                throw ((UncheckedIOException)re).getCause();
            }
            throw re;
        }
    }
}

