/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.collection.builder;

import com.geoway.vtile.commons.collection.builder.AbstractBuilder;
import com.geoway.vtile.commons.collection.builder.Builder;
import com.geoway.vtile.commons.util.UnsafeFuntion;
import java.nio.ByteBuffer;

public class ByteBuilder
extends AbstractBuilder<byte[]>
implements Builder<byte[]> {
    public ByteBuilder() {
    }

    public ByteBuilder(byte[] arr) {
        super(arr);
    }

    public ByteBuilder(int size) {
        super(size);
    }

    @Override
    public Builder<byte[]> append(byte[] arr) {
        return (ByteBuilder)super.append(arr, 0, arr.length);
    }

    public ByteBuilder append(byte[] arr, int offset, int length) {
        return (ByteBuilder)super.append(arr, offset, length);
    }

    @Override
    byte[] createHeap(int size) {
        return new byte[size];
    }

    public byte get(int index) {
        if (this.isDirect.booleanValue()) {
            this.getClass();
            int dataBlockIndex = (index *= this.typeSize) / 0x100000;
            this.getClass();
            int bindex = index % 0x100000;
            return ((ByteBuffer)this.directBufferArr.get(dataBlockIndex)).get(bindex);
        }
        return ((byte[])this.heap)[index];
    }

    public void set(int index, byte d) {
        if (index >= this.size) {
            throw new RuntimeException("out of range");
        }
        if (this.isDirect.booleanValue()) {
            this.getClass();
            int dataBlockIndex = (index *= this.typeSize) / 0x100000;
            this.getClass();
            int bIndex = index % 0x100000;
            ((ByteBuffer)this.directBufferArr.get(dataBlockIndex)).put(bIndex, d);
        } else {
            ((byte[])this.heap)[index] = d;
        }
    }

    public ByteBuilder append(byte d) {
        int off = 1;
        if (this.size + off > this.capacity) {
            this.ensureCapacityInternal(1);
        }
        if (this.isDirect.booleanValue()) {
            this.currentDirectByteBuffer.put(d);
        } else {
            ((byte[])this.heap)[this.size] = d;
        }
        ++this.size;
        return this;
    }

    @Override
    protected long getHeapTypeOffset() {
        return UnsafeFuntion.byteArrayOffset;
    }

    @Override
    protected int getHeapTypeOff() {
        return 0;
    }

    @Override
    protected int getHeapSize(byte[] heap) {
        return heap.length;
    }

    @Override
    int getTypeSize() {
        return 1;
    }
}

