/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.reflect;

import com.geoway.vtile.commons.reflect.BeanHolderManager;
import com.geoway.vtile.commons.reflect.FunctionHolderManager;
import com.geoway.vtile.commons.reflect.InvokerManager;
import com.geoway.vtile.commons.reflect.ReflectFindException;
import com.geoway.vtile.commons.reflect.beanHolder.BeanHolderManagerImpl;
import com.geoway.vtile.commons.reflect.functionHolder.FunctionHolderManagerImpl;
import com.geoway.vtile.commons.reflect.invoker.JavassistInvokerManagerImpl;

public class Reflect {
    private static InvokerManager _InvokerManager = new JavassistInvokerManagerImpl();
    private static BeanHolderManager _BeanHolderManager = new BeanHolderManagerImpl();
    private static FunctionHolderManager _functionHolderManager = new FunctionHolderManagerImpl();
    static ClassLoader CLASS_LOADER = null;

    public static void setClassLoader(ClassLoader classloader) {
        CLASS_LOADER = classloader;
    }

    public static ClassLoader getClassLoader() {
        if (CLASS_LOADER == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return CLASS_LOADER;
    }

    public static InvokerManager getInvokerManager() {
        return _InvokerManager;
    }

    public static BeanHolderManager getBeanHolderManager() {
        return _BeanHolderManager;
    }

    public static FunctionHolderManager getFunctionHolderManager() {
        return _functionHolderManager;
    }

    public static <T> T getObjectInstance(Class<T> clazz) throws ReflectFindException {
        try {
            T o = clazz.newInstance();
            return o;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new ReflectFindException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ReflectFindException(e.getMessage());
        }
    }

    public static Class<?> getObjectClass(String clazzName) throws ReflectFindException {
        try {
            Class<?> o = Class.forName(clazzName, true, Reflect.getClassLoader());
            return o;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new ReflectFindException(e.getMessage());
        }
    }
}

