/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.spatial;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.locationtech.jts.io.ByteOrderValues;

public class ByteOrderDataInStream {
    private int byteOrder = 1;
    private ByteArrayInputStream stream;
    boolean hex = false;
    private byte[] buf1;
    private byte[] buf4;
    private byte[] buf8;

    public ByteOrderDataInStream() {
        this(null, false);
    }

    public ByteOrderDataInStream(ByteArrayInputStream stream) {
        this(stream, false);
    }

    public ByteOrderDataInStream(ByteArrayInputStream stream, boolean hex) {
        this.stream = stream;
        this.hex = hex;
        this.buf1 = new byte[1 * (hex ? 2 : 1)];
        this.buf4 = new byte[4 * (hex ? 2 : 1)];
        this.buf8 = new byte[8 * (hex ? 2 : 1)];
    }

    public void setInStream(ByteArrayInputStream stream) {
        this.stream = stream;
    }

    public void setOrder(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    public byte readByte() throws IOException {
        this.stream.read(this.buf1);
        if (this.hex) {
            ByteOrderDataInStream.decodeHex(this.buf1, 1);
        }
        return this.buf1[0];
    }

    public byte[] readByte4() throws IOException {
        this.stream.read(this.buf4);
        if (this.hex) {
            ByteOrderDataInStream.decodeHex(this.buf4, 1);
        }
        return this.buf4;
    }

    public int readInt() throws IOException {
        this.stream.read(this.buf4);
        if (this.hex) {
            ByteOrderDataInStream.decodeHex(this.buf4, 4);
        }
        return ByteOrderValues.getInt((byte[])this.buf4, (int)this.byteOrder);
    }

    public long readLong() throws IOException {
        this.stream.read(this.buf8);
        if (this.hex) {
            ByteOrderDataInStream.decodeHex(this.buf8, 8);
        }
        return ByteOrderValues.getLong((byte[])this.buf8, (int)this.byteOrder);
    }

    public double readDouble() throws IOException {
        this.stream.read(this.buf8);
        if (this.hex) {
            ByteOrderDataInStream.decodeHex(this.buf8, 8);
        }
        return ByteOrderValues.getDouble((byte[])this.buf8, (int)this.byteOrder);
    }

    public static void decodeHex(byte[] buffer, int nBytes) {
        if (buffer.length < nBytes * 2) {
            throw new IllegalArgumentException("byte array length invalid.");
        }
        for (int i = 0; i < nBytes; ++i) {
            buffer[i] = (byte)(((ByteOrderDataInStream.unhex(buffer[2 * i]) & 0xFF) << 4) + (ByteOrderDataInStream.unhex(buffer[2 * i + 1]) & 0xFF) - 256);
        }
    }

    public static byte unhex(byte hexC) {
        char c = (char)hexC;
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(c - 97 + 10);
        }
        throw new IllegalArgumentException("Not valid Hex char " + c);
    }
}

