/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.util;

public final class WatchDog {
    private final String label;
    private long begin = 0L;
    private long end = 0L;
    private boolean showInSec = false;

    public WatchDog() {
        this(null, false);
    }

    public WatchDog(String label) {
        this(label, false);
    }

    public WatchDog(String label, boolean showInSec) {
        this.label = label;
        this.showInSec = showInSec;
        this.start();
    }

    public void setShowInSec(boolean showInSec) {
        this.showInSec = showInSec;
    }

    public void start() {
        this.begin = System.currentTimeMillis();
    }

    public long stop() {
        this.end = System.currentTimeMillis();
        return this.end - this.begin;
    }

    public void suspend() {
        this.end = System.currentTimeMillis();
    }

    public void resume() {
        this.begin += System.currentTimeMillis() - this.end;
    }

    public void reset() {
        this.begin = 0L;
        this.end = 0L;
    }

    public long elapsed() {
        if (this.end != 0L) {
            return this.end - this.begin;
        }
        return System.currentTimeMillis() - this.begin;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.label != null) {
            buf.append(this.label + " use : ");
        }
        long t = this.elapsed();
        buf.append(t);
        buf.append(" ms");
        return buf.toString();
    }
}

