/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.type;

import com.geoway.vtile.exception.NotSupport;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.Geom;
import com.geoway.vtile.type.AbstractType;
import com.geoway.vtile.type.Type;
import com.geoway.vtile.type.Types;

public abstract class TypeGeometry
extends AbstractType
implements Type {
    public abstract Constants.SPATIAL_TYPE getSpatialType();

    public TypeGeometry() {
        super(Types.TYPE_ENUM.Geometry);
    }

    @Override
    public Class<?> getJavaClass() {
        return Geom.class;
    }

    @Override
    public boolean isType(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Geom) {
            return ((Geom)o).getType() == this.getSpatialType();
        }
        return false;
    }

    @Override
    public Object strToType(String str) {
        this.stringNull(str);
        return new Geom(Constants.SPATIAL_TYPE.wkt, str);
    }

    @Override
    public String valueToString(Object o) {
        if (o == null) {
            return null;
        }
        this.testType(this, o);
        Geom geom = (Geom)o;
        return geom.toWkt();
    }

    @Override
    public Object toType(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof Geom)) {
            throw new RuntimeException("\u8f6c\u6362\u7c7b\u578b\u5fc5\u987b\u4e3aGeom");
        }
        Geom geom = (Geom)o;
        geom.changeType(this.getSpatialType());
        return geom;
    }

    @Override
    public Boolean isTypePrimitive(Object o) {
        return false;
    }

    @Override
    Object nativeChange(Object o) {
        throw new NotSupport();
    }

    @Override
    Object numberChange(Number o) {
        throw new NotSupport();
    }

    @Override
    public String getIsTypeScript() {
        StringBuilder sb = new StringBuilder();
        sb.append("com.geoway.vtile.spatial.Geom geom = (com.geoway.vtile.spatial.Geom)obj;");
        sb.append("if(geom.getType() == ").append(this.getClass().getName()).append(".INSTANCE.getSpatialType()){");
        sb.append("return ").append(this.getClass().getName()).append(".INSTANCE;");
        sb.append("};");
        return sb.toString();
    }
}

