/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.dataschema.dao;

import com.geoway.vtile.dataschema.bean.DataDetailQueryBean;
import com.geoway.vtile.dataschema.bean.GeometryInfo;
import com.geoway.vtile.dataschema.bean.Index;
import com.geoway.vtile.dataschema.bean.TableColumn;
import com.geoway.vtile.dataschema.connection.HbaseConnectionImpl;
import com.geoway.vtile.dataschema.connection.SparkConnectionImpl;
import com.geoway.vtile.dataschema.dao.IRelationSpatialDao;
import com.geoway.vtile.dataschema.dao.impl.HbaseSpatialDao;
import com.geoway.vtile.dataschema.dao.impl.HighgoSpatialDao;
import com.geoway.vtile.dataschema.dao.impl.KingbaseSpatialDao;
import com.geoway.vtile.dataschema.dao.impl.MysqlSpatialDao;
import com.geoway.vtile.dataschema.dao.impl.OgrSpatialDao;
import com.geoway.vtile.dataschema.dao.impl.OracleSpatialDao;
import com.geoway.vtile.dataschema.dao.impl.PostgresSpatialDao;
import com.geoway.vtile.dataschema.dao.impl.SparkSpatialDao;
import com.geoway.vtile.dataschema.datasource.DataSource;
import com.kingbase8.jdbc.KbConnection;
import com.mysql.cj.jdbc.ConnectionImpl;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jdbc.driver.OracleConnection;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.postgresql.jdbc.PgConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationSpatialDao
implements IRelationSpatialDao {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Connection conn;
    protected DataSource.DataSourceType type;

    public RelationSpatialDao(Connection conn) {
        this.conn = conn;
    }

    public static RelationSpatialDao getInstance(Connection conn) throws SQLException {
        if (conn instanceof HbaseConnectionImpl) {
            return new HbaseSpatialDao(conn);
        }
        if (conn instanceof SparkConnectionImpl) {
            return new SparkSpatialDao(conn);
        }
        if (conn.getClass().getName().equals("com.geoway.vtile.dataschema.connection.OgrConnectionImpl")) {
            return new OgrSpatialDao(conn);
        }
        if (conn.getMetaData().getConnection() instanceof PgConnection) {
            return new PostgresSpatialDao(conn);
        }
        if (conn.getMetaData().getConnection() instanceof ConnectionImpl) {
            return new MysqlSpatialDao(conn);
        }
        if (conn.getMetaData().getConnection() instanceof OracleConnection) {
            return new OracleSpatialDao(conn);
        }
        if (conn.getMetaData().getConnection() instanceof KbConnection) {
            return new KingbaseSpatialDao(conn);
        }
        if (conn.getMetaData().getConnection() instanceof com.highgo.jdbc.jdbc.PgConnection) {
            return new HighgoSpatialDao(conn);
        }
        return null;
    }

    @Override
    public void dropTable(String tableName) {
    }

    @Override
    public void dropView(String viewName) {
    }

    @Override
    public Map<String, Object> getTableDatas(String tableName, String geometryField, DataDetailQueryBean filter, Connection conn) throws Exception {
        return this.getTableDatas(tableName, geometryField, filter, conn, null, null);
    }

    @Override
    public Map<String, Object> getTableDatas(String tableName, String geometryField, DataDetailQueryBean filter, Connection conn, String sortField, String sortType) throws Exception {
        Integer pageIndex = filter.getPageIndex();
        Integer rows = filter.getRows();
        String keyWord = filter.getKeyWord();
        String wkt = filter.getWkt();
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<TableColumn> Fields = this.getFields(tableName);
        GeometryInfo geoInfo = this.getGeometryInfo(tableName, geometryField);
        String geomField = geoInfo.getGeometryFieldName();
        String geoType = geoInfo.getType().name();
        Map<String, Object> datas = this.list(tableName, conn, pageIndex, rows, keyWord, wkt, geomField, Fields, sortField, sortType);
        datas.put("geometryField", geomField);
        result.put("data", datas);
        return result;
    }

    @Override
    public void isValidate() {
        try {
            String sql = "select 1";
            if (this instanceof OracleSpatialDao) {
                sql = sql + " from dual";
            }
            Statement stmt = this.conn.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            throw new RuntimeException("\u7a7a\u95f4\u6570\u636e\u6e90\u9519\u8bef", e);
        }
        finally {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void checkViewVid(String viewName) throws SQLException {
        Statement st = this.conn.createStatement();
        String sql = "select vid from " + viewName;
        try {
            st.execute(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException("\u89c6\u56fe\u5fc5\u987b\u5305\u542bvid\u5b57\u6bb5");
        }
    }

    @Override
    public abstract List<TableColumn> getFieldsWithCommit(String var1) throws SQLException;

    protected abstract Map<String, Object> list(String var1, Connection var2, Integer var3, Integer var4, String var5, String var6, String var7, List<TableColumn> var8) throws SQLException;

    protected abstract Map<String, Object> list(String var1, Connection var2, Integer var3, Integer var4, String var5, String var6, String var7, List<TableColumn> var8, String var9, String var10) throws SQLException;

    public abstract DataSource.DataSourceType getType();

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public abstract List<Index> getIndexes(String var1) throws SQLException;

    @Override
    public Double[] getBBox(String tableName, String field) throws SQLException {
        String wkt = this.getExtent(tableName, field);
        if (StringUtils.isBlank((CharSequence)wkt)) {
            return null;
        }
        Double[] bbox = null;
        try {
            Geometry geometry = new WKTReader().read(wkt);
            Envelope envelope = geometry.getEnvelopeInternal();
            bbox = new Double[]{envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY()};
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return bbox;
    }
}

