/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.dataschema.dao.impl;

import com.geoway.vtile.dataschema.bean.GeomeryColumn;
import com.geoway.vtile.dataschema.bean.GeometryInfo;
import com.geoway.vtile.dataschema.bean.GeometryType;
import com.geoway.vtile.dataschema.bean.Index;
import com.geoway.vtile.dataschema.bean.PageResult;
import com.geoway.vtile.dataschema.bean.SpatialDataSet;
import com.geoway.vtile.dataschema.bean.TableColumn;
import com.geoway.vtile.dataschema.bean.UpdateNodeBean;
import com.geoway.vtile.dataschema.constants.ProjSRIDType;
import com.geoway.vtile.dataschema.dao.RelationSpatialDao;
import com.geoway.vtile.dataschema.datasource.DataSource;
import com.geoway.vtile.dataschema.exception.BusinessException;
import com.geoway.vtile.dataschema.utils.PreparedStatementUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KingbaseSpatialDao
extends RelationSpatialDao {
    protected DataSource.DataSourceType type = DataSource.DataSourceType.postgres;
    Logger logger = LoggerFactory.getLogger(KingbaseSpatialDao.class);
    String prifix = "sys_";

    public KingbaseSpatialDao(Connection conn) {
        super(conn);
        try {
            if (conn.getMetaData().getDatabaseMajorVersion() >= 12) {
                this.prifix = "pg_";
            }
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }

    @Override
    public DataSource.DataSourceType getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeometryInfo getGeometryInfo(String tableName, String geometryField) throws SQLException {
        StringBuffer sql = new StringBuffer();
        String schema = "public";
        if (tableName.contains(".")) {
            String[] arr = tableName.split("\\.");
            schema = arr[0];
            tableName = arr[1];
        }
        sql.append("select f_geometry_column,srid,type from geometry_columns where  f_table_name = ? and f_table_schema = ?");
        if (StringUtils.isNotEmpty((CharSequence)geometryField)) {
            sql.append(" and f_geometry_column = ?");
        }
        int geoFieldsNum = 0;
        GeometryInfo info = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(sql.toString());
            ps.setString(1, tableName);
            ps.setString(2, schema);
            if (StringUtils.isNotEmpty((CharSequence)geometryField)) {
                ps.setString(3, geometryField);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                info = new GeometryInfo();
                String shapeField = rs.getString("f_geometry_column");
                String geometryType = rs.getString("type");
                Integer srid = rs.getInt("srid");
                if (StringUtils.isBlank((CharSequence)geometryType)) {
                    geometryType = "GEOMETRY";
                }
                if ("GEOMETRY".equals(geometryType) || srid == 0) {
                    info = this.getGeometryInfoByRow(schema, tableName, this.conn, shapeField);
                    if (info == null) {
                        throw new BusinessException("\u8868" + tableName + "\u4e3a\u7a7a\u6216\u65e0\u7a7a\u95f4\u5b57\u6bb5");
                    }
                    geometryType = info.getType().toString();
                    srid = info.getSrid();
                }
                info.setGeometryFieldName(shapeField);
                info.setSrid(srid);
                info.setType(GeometryType.valueOf(geometryType));
                ++geoFieldsNum;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        if (geoFieldsNum > 1) {
            throw new BusinessException("\u8bf7\u660e\u786e\u6307\u5b9a\u7a7a\u95f4\u5b57\u6bb5");
        }
        return info;
    }

    private GeometryInfo getGeometryInfoByRow(String schema, String tableName, Connection conn, String shapeField) throws SQLException {
        GeometryInfo info = null;
        String typeSql = "SELECT GeometryType(" + shapeField + ") as type, st_asewkt(" + shapeField + ") as ewkt from \"" + schema + "\".\"" + tableName + "\" where " + shapeField + " is not null limit  1  offset 0";
        String geometryType = null;
        String ewkt = null;
        Integer srid = null;
        try (PreparedStatement nps = conn.prepareStatement(typeSql);
             ResultSet nrs = nps.executeQuery();){
            while (nrs.next()) {
                srid = 0;
                info = new GeometryInfo();
                geometryType = nrs.getString("type");
                ewkt = nrs.getString("ewkt");
                String sridStr = ewkt.split(";")[0];
                String[] arr = sridStr.split("=");
                if (arr.length > 1) {
                    srid = Integer.valueOf(arr[1]);
                }
                info.setType(GeometryType.valueOf(geometryType));
                info.setSrid(srid);
            }
        }
        return info;
    }

    @Override
    public Integer getSrid(String tableName) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getExtent(String tableName, String field) throws SQLException {
        String schema = "public";
        if (tableName.contains(".")) {
            String[] arr = tableName.split("\\.");
            schema = arr[0];
            tableName = arr[1];
        }
        String sql = "select ST_ASTEXT(ST_EstimatedExtent(?,?,?)) as wkt ";
        PreparedStatement ps = null;
        ResultSet rs = null;
        String wkt = null;
        try {
            ps = this.conn.prepareStatement(sql);
            ps.setString(1, schema);
            ps.setString(2, tableName);
            ps.setString(3, field);
            rs = ps.executeQuery();
            while (rs.next()) {
                wkt = rs.getString("wkt");
            }
            rs.close();
            ps.close();
            if (wkt == null) {
                String sqlStr = "select ST_ASTEXT(st_extent(\"" + field + "\")) as wkt from \"" + schema + "\".\"" + tableName + "\"";
                ps = this.conn.prepareStatement(sqlStr);
                rs = ps.executeQuery();
                while (rs.next()) {
                    wkt = rs.getString("wkt");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8868" + tableName + "\u7684" + field + "\u5b57\u6bb5\u7684\u7a7a\u95f4\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25");
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return wkt;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Boolean exists(String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getPk(String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getPkByTables(List<String> tableNames) throws SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (tableNames == null || tableNames.isEmpty()) {
            return result;
        }
        StringBuffer columnSql = new StringBuffer();
        StringBuffer placeholder = new StringBuffer();
        for (String tableName : tableNames) {
            placeholder.append(placeholder.length() == 0 ? "?" : ",?");
        }
        columnSql.append(" SELECT ").append(this.prifix).append("attribute.attname AS colname, ").append(this.prifix).append("class.relname as relname, ").append(this.prifix).append("namespace.nspname AS schema");
        columnSql.append(" FROM\t").append(this.prifix).append("constraint ");
        columnSql.append(" INNER JOIN ").append(this.prifix).append("class ON ").append(this.prifix).append("constraint.conrelid = ").append(this.prifix).append("class.oid\t");
        columnSql.append(" INNER JOIN ").append(this.prifix).append("attribute ON ").append(this.prifix).append("attribute.attrelid = ").append(this.prifix).append("class.oid  AND ").append(this.prifix).append("attribute.attnum = ").append(this.prifix).append("constraint.conkey [ 1 ] ");
        columnSql.append(" INNER JOIN ").append(this.prifix).append("namespace ON ").append(this.prifix).append("class.relnamespace = ").append(this.prifix).append("namespace.oid ");
        columnSql.append(" WHERE ").append(this.prifix).append("class.relname in ( ").append(placeholder).append(" ) AND ").append(this.prifix).append("constraint.contype = 'p'");
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(columnSql.toString());
            for (int i = 0; i < tableNames.size(); ++i) {
                ps.setString(i + 1, tableNames.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                result.put(rs.getString("schema") + "." + rs.getString("relname"), rs.getString("colname"));
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<TableColumn> getFields(String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<TableColumn> getFieldsWithCommit(String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> getFieldNames(String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected Map<String, Object> list(String tableName, Connection conn, Integer pageIndex, Integer rows, String keyWord, String wkt, String geomField, List<TableColumn> Fields) throws SQLException {
        return this.list(tableName, conn, pageIndex, rows, keyWord, wkt, geomField, Fields, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> list(String tableName, Connection conn, Integer pageIndex, Integer rows, String keyWord, String wkt, String geomField, List<TableColumn> Fields, String sortField, String sortType) throws SQLException {
        Statement ps = null;
        ResultSet rs = null;
        HashMap<String, Object> datas = new HashMap<String, Object>();
        ArrayList<String> allFields = new ArrayList<String>();
        ArrayList dataslist = new ArrayList();
        ArrayList<String> searchFields = new ArrayList<String>();
        try {
            String searchType = "text,integer,character varying,numeric,smallint";
            for (TableColumn field : Fields) {
                String type = field.getType();
                String name = field.getName();
                allFields.add(name);
                if (!searchType.contains(type)) continue;
                String notNullField = "COALESCE(" + name + " ,'')";
                if ("integer".equals(type) || "numeric".equals(type) || "smallint".equals(type)) {
                    notNullField = "COALESCE(" + name + " ,0)";
                }
                searchFields.add(notNullField);
            }
            List fieldsList = allFields.stream().map(dd -> dd).collect(Collectors.toList());
            fieldsList.remove(geomField);
            fieldsList.add("ST_AsText(" + geomField + ") as geom");
            String allFieldsStr = StringUtils.join(fieldsList, (String)",");
            String text = StringUtils.join(searchFields, (String)"||'-'||");
            text = "'' || " + text;
            StringBuffer sql = new StringBuffer();
            sql.append("select ");
            sql.append(allFieldsStr);
            sql.append(" from ");
            sql.append(tableName);
            sql.append(" where 1=1 ");
            ArrayList<Object> paras = new ArrayList<Object>();
            if (keyWord != null && !"".equals(keyWord)) {
                sql.append(" and ");
                sql.append(text);
                sql.append(" like ?");
                paras.add("%" + keyWord + "%");
            }
            if (wkt != null && !"".equals(wkt)) {
                sql.append(" and ");
                sql.append(geomField);
                sql.append(" && st_geomfromtext(?)");
                paras.add(wkt);
            }
            ps = conn.prepareStatement(sql.toString().replace(allFieldsStr, "count(*) as num"));
            rs = PreparedStatementUtils.executeQuery((PreparedStatement)ps, paras);
            long count = -1L;
            while (rs.next()) {
                count = rs.getInt("num");
            }
            rs.close();
            ps.close();
            if (StringUtils.isNotBlank((CharSequence)sortField)) {
                String type = StringUtils.isNotEmpty((CharSequence)sortType) ? sortType : "ASC";
                sql.append(" ORDER BY ").append(sortField).append(" ").append(type);
            }
            paras.add(rows);
            paras.add(pageIndex * rows);
            sql.append(" limit ?");
            sql.append(" offset ?");
            ps = conn.prepareStatement(sql.toString());
            rs = PreparedStatementUtils.executeQuery((PreparedStatement)ps, paras);
            int fieldsNum = allFields.size();
            allFields.remove(geomField);
            allFields.add("geom");
            HashMap<String, Object> row = null;
            String field = null;
            dataslist = new ArrayList();
            while (rs.next()) {
                row = new HashMap<String, Object>();
                for (int i = 0; i < fieldsNum; ++i) {
                    field = (String)allFields.get(i);
                    row.put(field, rs.getObject(field));
                }
                dataslist.add(row);
            }
            datas.put("count", count);
            datas.put("columns", allFields);
            datas.put("data", dataslist);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return datas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageResult<SpatialDataSet> getSpatialTable(Integer pageIndex, Integer rows, String keyWord) throws SQLException {
        if (StringUtils.isEmpty((CharSequence)keyWord)) {
            keyWord = "";
        }
        ArrayList<SpatialDataSet> results = new ArrayList<SpatialDataSet>();
        String srid = StringUtils.join(ProjSRIDType.ProjSRID.keySet(), (String)",");
        String baseSql = " SELECT f_table_name, f_table_schema, array_to_string(array_agg(srid), ',') as srids, array_to_string(array_agg(f_geometry_column), ',') as geoms ,(SELECT CAST ( obj_description ( relfilenode, '" + this.prifix + "class' ) AS VARCHAR ) AS COMMENT FROM " + this.prifix + "class C LEFT JOIN " + this.prifix + "namespace n ON n.oid = C.relnamespace WHERE n.nspname = f_table_schema AND relname = f_table_name  ) AS comm FROM geometry_columns  WHERE srid in (" + srid + ")  and UPPER(f_table_name) like ?  group by f_table_name, f_table_schema ";
        String pageSql = baseSql + " order by f_table_name limit ? offset ? ";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(pageSql);
            rs = PreparedStatementUtils.executeQuery(ps, new Object[]{"%" + StringUtils.upperCase((String)keyWord) + "%", rows, rows * pageIndex});
            String[] srids = null;
            String[] geoms = null;
            while (rs.next()) {
                SpatialDataSet elment = new SpatialDataSet();
                elment.setName(rs.getString("f_table_schema") + "." + rs.getString("f_table_name"));
                elment.setIndexes(this.getIndexes(elment.getName()));
                srids = rs.getString("srids").split(",");
                geoms = rs.getString("geoms").split(",");
                ArrayList<GeomeryColumn> list = new ArrayList<GeomeryColumn>();
                for (int i = 0; i < srids.length; ++i) {
                    list.add(new GeomeryColumn(geoms[i], Integer.parseInt(srids[i]), null));
                }
                if (srids.length == 1) {
                    elment.setSrid(Integer.parseInt(srids[0]));
                }
                elment.setGeomeryColumnList(list);
                elment.setComment(rs.getString("comm"));
                results.add(elment);
            }
            rs.close();
            ps.close();
            String countSql = "select count(*) from ( " + baseSql + " ) o";
            ps = this.conn.prepareStatement(countSql);
            rs = PreparedStatementUtils.executeQuery(ps, new Object[]{"%" + StringUtils.upperCase((String)keyWord) + "%"});
            Long count = 0L;
            while (rs.next()) {
                count = rs.getLong("count");
            }
            PageResult<SpatialDataSet> pageResult = new PageResult<SpatialDataSet>(count, results);
            return pageResult;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    @Override
    public PageResult<SpatialDataSet> getSpatialTableWithColumns(Integer pageIndex, Integer rows, String keyWord) throws SQLException {
        PageResult<SpatialDataSet> tablePages = this.getSpatialTable(pageIndex, rows, keyWord);
        List<SpatialDataSet> tables = tablePages.getData();
        ArrayList<String> tableNames = new ArrayList<String>();
        for (SpatialDataSet item : tables) {
            tableNames.add(item.getName());
        }
        Set<String> views = this.getViews(tableNames);
        Map<String, List<TableColumn>> tablesColumns = this.getSpatialColumns(tableNames);
        List<Object> columns = new ArrayList();
        if (tables != null && !tables.isEmpty()) {
            for (int i = 0; i < tables.size(); ++i) {
                SpatialDataSet elment;
                columns = tablesColumns.get((elment = tables.get(i)).getName());
                elment.setColumnList(columns == null ? new ArrayList() : columns);
                elment.setIsView(views.contains(elment.getName()));
            }
        }
        return tablePages;
    }

    @Override
    public boolean checkSpatial(String tableName, String geometryField) throws SQLException {
        boolean isView = this.isView(tableName);
        if (isView) {
            this.checkViewVid(tableName);
        } else {
            String pk = this.getPk(tableName);
            if (StringUtils.isEmpty((CharSequence)pk)) {
                throw new BusinessException("\u8868 " + tableName + " \u7f3a\u5c11\u4e3b\u952e");
            }
            String schema = "public";
            if (tableName.indexOf(".") != -1) {
                String[] arr = tableName.split("\\.");
                schema = arr[0];
                tableName = arr[1];
            }
            this.checkPkIdx(schema, tableName, pk);
            this.checkSpatialIndex(schema, tableName, geometryField);
        }
        return true;
    }

    public void checkPkIdx(String schema, String tableName, String pkName) throws SQLException {
        if (!this.checkIdx(schema, tableName, pkName)) {
            throw new RuntimeException("\u8868" + schema + "." + tableName + " \u5b57\u6bb5 " + pkName + " \u7f3a\u5c11\u4e3b\u952e\u7d22\u5f15, \u8bf7\u5728\u6570\u636e\u5e93\u4e2d\u521b\u5efa\u4e3b\u952e\u7d22\u5f15\u4ee5\u63d0\u5347\u67e5\u8be2\u6548\u7387");
        }
    }

    public void checkSpatialIndex(String schema, String tableName, String geometryField) throws SQLException {
        if (!this.checkIdx(schema, tableName, geometryField)) {
            throw new RuntimeException("\u8868" + schema + "." + tableName + " \u7a7a\u95f4\u5b57\u6bb5 " + geometryField + " \u4e0d\u5b58\u5728\u6216\u7f3a\u5c11\u7a7a\u95f4\u7d22\u5f15");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIdx(String schema, String tableName, String field) throws SQLException {
        String classSql = "SELECT c.oid FROM " + this.prifix + "class c left join " + this.prifix + "namespace n on n.oid = c.relnamespace  WHERE c.relname = ? and n.nspname = ?";
        Long oid = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(classSql);
            rs = PreparedStatementUtils.executeQuery(ps, new Object[]{tableName, schema});
            while (rs.next()) {
                oid = rs.getLong("oid");
            }
            rs.close();
            ps.close();
            if (oid == null) {
                throw new RuntimeException("\u8868" + schema + "." + tableName + "\u4e0d\u5b58\u5728");
            }
            String sql = "SELECT count(*) as count FROM " + this.prifix + "index WHERE " + this.prifix + "index.indrelid = ? AND " + this.prifix + "index.indkey [ 0 ] = ( SELECT attnum FROM " + this.prifix + "attribute WHERE attrelid = ?  AND attname = ? )";
            ps = this.conn.prepareStatement(sql);
            rs = PreparedStatementUtils.executeQuery(ps, new Object[]{oid, oid, field});
            Integer count = null;
            while (rs.next()) {
                count = rs.getInt("count");
            }
            boolean bl = count != null && count > 0;
            return bl;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<TableColumn>> getSpatialColumns(List<String> tableNames) throws SQLException {
        HashMap<String, List<TableColumn>> results = new HashMap<String, List<TableColumn>>();
        if (tableNames == null || tableNames.isEmpty()) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList schemas = new ArrayList();
        tableNames.forEach(tableName -> {
            String[] arr = tableName.split("\\.");
            schemas.add(arr[0]);
            names.add(arr[1]);
        });
        Map<String, String> pkTables = this.getPkByTables(names);
        StringBuilder placeholder = new StringBuilder();
        for (String tableName2 : names) {
            placeholder.append(placeholder.length() == 0 ? "?" : ",?");
        }
        String sqlColumn = "SELECT C.relname AS tablename, T.typname AS typename, N.nspname AS schema, A.attname FROM " + this.prifix + "class AS C, " + this.prifix + "namespace AS N, " + this.prifix + "attribute AS A, " + this.prifix + "type AS T WHERE A.attrelid = C.oid AND A.attnum > 0  AND C.relnamespace = N.oid  AND A.attisdropped <> 't' AND C.relname IN (" + placeholder + ") AND T.oid = A.atttypid ";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(sqlColumn);
            for (int i = 0; i < names.size(); ++i) {
                ps.setString(i + 1, (String)names.get(i));
            }
            rs = ps.executeQuery();
            String tableName3 = null;
            String field = null;
            String fieldType = null;
            String schema = null;
            TableColumn data = null;
            ArrayList<TableColumn> columns = null;
            while (rs.next()) {
                tableName3 = rs.getString("tablename");
                schema = rs.getString("schema");
                fieldType = rs.getString("typename");
                field = rs.getString("attname");
                columns = (ArrayList<TableColumn>)results.get(schema + "." + tableName3);
                if (columns == null) {
                    columns = new ArrayList<TableColumn>();
                    results.put(schema + "." + tableName3, columns);
                }
                data = new TableColumn();
                data.setName(field);
                data.setType(fieldType);
                data.setIsPrimary(field.equals(pkTables.get(schema + "." + tableName3)));
                columns.add(data);
            }
            HashMap<String, List<TableColumn>> hashMap = results;
            return hashMap;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public Set<String> getViews(List<String> tableNames) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isView(String viewName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean isMaterializedView(String viewName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, List<UpdateNodeBean>> getUpdateNode(String schema) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getSequenceNameForTable(String tableName) throws SQLException {
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Index> getIndexes(String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

