/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.dataschema.dao.impl;

import com.geoway.vtile.dataschema.bean.GeomeryColumn;
import com.geoway.vtile.dataschema.bean.GeometryInfo;
import com.geoway.vtile.dataschema.bean.GeometryType;
import com.geoway.vtile.dataschema.bean.Index;
import com.geoway.vtile.dataschema.bean.PageResult;
import com.geoway.vtile.dataschema.bean.SpatialDataSet;
import com.geoway.vtile.dataschema.bean.TableColumn;
import com.geoway.vtile.dataschema.bean.UpdateNodeBean;
import com.geoway.vtile.dataschema.connection.HbaseConnectionImpl;
import com.geoway.vtile.dataschema.dao.RelationSpatialDao;
import com.geoway.vtile.dataschema.datasource.DataSource;
import com.geoway.vtile.resources.datasource.hbase.connection.HbaseConnection;
import com.geoway.vtile.resources.hbasemeta.ColumnMeta;
import com.geoway.vtile.resources.hbasemeta.HBaseTableMeta;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.WKTReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbaseSpatialDao
extends RelationSpatialDao {
    Logger logger;
    private DataSource.DataSourceType type;
    private HbaseConnectionImpl hbaseConnection;
    private static GeometryFactory geomFactory = new GeometryFactory();

    public HbaseSpatialDao(Connection conn) {
        super(conn);
        this.hbaseConnection = (HbaseConnectionImpl)conn;
        this.logger = LoggerFactory.getLogger(HbaseSpatialDao.class);
        this.type = DataSource.DataSourceType.hbase;
    }

    @Override
    public DataSource.DataSourceType getType() {
        return this.type;
    }

    @Override
    public Boolean exists(String tableName) throws SQLException {
        try {
            return HBaseTableMeta.exists((HbaseConnection)this.hbaseConnection, (String)tableName);
        }
        catch (Exception e) {
            this.logger.error("\u8fde\u63a5\u8d85\u65f6\u6216\u4e0d\u5b58\u5728");
            throw new RuntimeException("\u8fde\u63a5\u8d85\u65f6\u6216\u4e0d\u5b58\u5728" + e.getMessage());
        }
    }

    @Override
    public String getPk(String tableName) {
        return "FID";
    }

    @Override
    public List<TableColumn> getFields(String tableName) throws SQLException {
        try {
            List metas = HBaseTableMeta.getFields((HbaseConnection)this.hbaseConnection, (String)tableName);
            return metas.stream().map(m -> {
                TableColumn tcol = new TableColumn();
                tcol.setName(m.getName());
                tcol.setType(m.getType());
                tcol.setAlias(m.getAlias());
                tcol.setIsPrimary(m.getKey());
                return tcol;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u5b57\u6bb5\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public List<TableColumn> getFieldsWithCommit(String tableName) throws SQLException {
        return this.getFields(tableName);
    }

    @Override
    public List<String> getFieldNames(String tableName) {
        try {
            List metas = HBaseTableMeta.getFields((HbaseConnection)this.hbaseConnection, (String)tableName);
            return metas.stream().map(ColumnMeta::getName).collect(Collectors.toList());
        }
        catch (Exception ex) {
            throw new RuntimeException("\u83b7\u53d6\u5b57\u6bb5\u5217\u8868\u5931\u8d25\uff1a" + ex.getMessage());
        }
    }

    @Override
    public boolean isView(String viewName) {
        return false;
    }

    @Override
    public GeometryInfo getGeometryInfo(String tableName, String geometryField) {
        try {
            List metas = HBaseTableMeta.getFields((HbaseConnection)this.hbaseConnection, (String)tableName);
            ColumnMeta geoCol = metas.stream().filter(c -> "shape".equals(c.getAlias())).findFirst().get();
            GeometryInfo info = new GeometryInfo();
            info.setGeometryFieldName(geoCol.getName());
            info.setType(GeometryType.valueOf(geoCol.getType().toUpperCase()));
            info.setSrid(geoCol.getSrid());
            return info;
        }
        catch (Exception ex) {
            throw new RuntimeException("\u83b7\u53d6\u5b57\u6bb5\u5217\u8868\u5931\u8d25\uff1a" + ex.getMessage());
        }
    }

    @Override
    public Integer getSrid(String tableName) {
        return HBaseTableMeta.getSRID((HbaseConnection)this.hbaseConnection, (String)tableName);
    }

    @Override
    public String getExtent(String tableName, String field) {
        return HBaseTableMeta.getExtentWKT((HbaseConnection)this.hbaseConnection, (String)tableName);
    }

    @Override
    public PageResult<SpatialDataSet> getSpatialTable(Integer pageIndex, Integer rows, String keyWord) {
        List tableNames = HBaseTableMeta.getTableList((HbaseConnection)this.hbaseConnection);
        int total = tableNames.size();
        int start = pageIndex * rows;
        int end = Math.min((pageIndex + 1) * rows, total);
        WKTReader wktReader = new WKTReader(geomFactory);
        Geometry geoExent = null;
        ArrayList<SpatialDataSet> results = new ArrayList<SpatialDataSet>();
        for (int i = start; i < end; ++i) {
            String tableName = (String)tableNames.get(i);
            try {
                int srid = HBaseTableMeta.getSRID((HbaseConnection)this.hbaseConnection, (String)tableName);
                List<TableColumn> fields = this.getFields(tableName);
                String extentWkt = HBaseTableMeta.getExtentWKT((HbaseConnection)this.hbaseConnection, (String)tableName);
                TableColumn geoCol = fields.stream().filter(c -> "shape".equals(c.getAlias())).findFirst().get();
                geoExent = wktReader.read(extentWkt);
                Envelope env = geoExent.getEnvelopeInternal();
                Double[] bbox = new Double[]{env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY()};
                SpatialDataSet element = new SpatialDataSet();
                element.setName(tableName);
                element.setGeometryType(geoCol.getType());
                GeomeryColumn geomeryColumn = new GeomeryColumn(geoCol.getName(), srid, geoCol.getType());
                element.setGeomeryColumnList(Collections.singletonList(geomeryColumn));
                element.setSrid(srid);
                element.setColumnList(fields);
                element.setIsView(false);
                results.add(element);
                continue;
            }
            catch (Exception ex) {
                throw new RuntimeException("\u83b7\u53d6\u7a7a\u95f4\u56fe\u5c42" + tableName + "\u7684\u5143\u6570\u636e\u5931\u8d25\uff1a" + ex.getMessage());
            }
        }
        return new PageResult<SpatialDataSet>(Long.valueOf(total), results);
    }

    @Override
    public PageResult<SpatialDataSet> getSpatialTableWithColumns(Integer pageIndex, Integer rows, String keyWord) throws SQLException {
        return this.getSpatialTable(pageIndex, rows, keyWord);
    }

    @Override
    public boolean checkSpatial(String tableName, String geometryField) {
        return true;
    }

    @Override
    public Map<String, List<UpdateNodeBean>> getUpdateNode(String schema) {
        throw new UnsupportedOperationException("not support");
    }

    @Override
    public String getSequenceNameForTable(String tableName) {
        return null;
    }

    @Override
    protected Map<String, Object> list(String tableName, Connection conn, Integer pageIndex, Integer rows, String keyWord, String wkt, String geomField, List<TableColumn> fields) throws SQLException {
        throw new UnsupportedOperationException("not support");
    }

    @Override
    protected Map<String, Object> list(String tableName, Connection conn, Integer pageIndex, Integer rows, String keyWord, String wkt, String geomField, List<TableColumn> fields, String sortField, String sortType) throws SQLException {
        throw new UnsupportedOperationException("not support");
    }

    @Override
    public List<Index> getIndexes(String tableName) {
        return null;
    }

    @Override
    public void isValidate() {
    }
}

