/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.dao;

import com.geoway.vtile.bean.IJsonable;
import com.geoway.vtile.bean.IJsonableBuilder;
import com.geoway.vtile.bean.Idable;
import com.geoway.vtile.dao.IMetaDataDao;
import com.geoway.vtile.dao.IPostgresDao;
import com.geoway.vtile.exception.Json2BeanFailedException;
import com.geoway.vtile.exception.NotFoundException;
import com.geoway.vtile.manager.IMetaDataManager;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datatable.dao.DataAccessException;
import com.geoway.vtile.resources.inmemoryold.IInmemoryFilter;
import com.geoway.vtile.resources.inmemoryold.QueryFilterToInMemory;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.structure.queryhashtable.QueryHashTableHeap;
import com.geoway.vtile.tools.redis.RedisCache;
import com.geoway.vtile.tools.redis.RedisEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetaDao<T extends IJsonable & Idable<String>, Builder extends IJsonableBuilder<T>>
implements IMetaDataDao<T> {
    Logger logger = LoggerFactory.getLogger(AbstractMetaDao.class);
    protected Client client;
    protected IPostgresDao<T> pgDao;
    protected RedisCache redis;
    protected IMetaDataManager<T> manager;
    protected QueryHashTableHeap<String, T> table;
    protected String idFieldName;
    protected String category;
    protected Builder beanBuilder;
    protected Boolean isReady = false;
    protected final Boolean readOnly;

    public AbstractMetaDao(String idFieldName, Builder beanBuilder, QueryHashTableHeap<String, T> table, Client client, String managerRoot, Boolean readOnly) {
        this.idFieldName = idFieldName;
        this.table = table;
        this.readOnly = readOnly;
        this.client = client;
        this.category = managerRoot;
        this.beanBuilder = beanBuilder;
    }

    @Override
    public void init() throws Exception {
        this.redis = new RedisCache();
        this.isReady = true;
    }

    @Override
    public void sync2Redis(T bean) throws Exception {
        String json = this.serializeBean((IJsonable)bean);
        this.redis.set(this.wrapKey((String)((Idable)bean).getId()), json);
    }

    protected String wrapKey(String id) {
        return this.category + ":" + id;
    }

    protected String serializeBean(IJsonable t) throws Exception {
        return t.toJson();
    }

    @Override
    public List<T> findAll() {
        return this.pgDao.findAll();
    }

    @Override
    public T findOne(String id) {
        try {
            T bean = this.getFromRedis(id);
            if (null != bean) {
                return bean;
            }
        }
        catch (Exception bean) {
            // empty catch block
        }
        try {
            this.logger.warn("redis\u7f13\u5b58\u7a7f\u900f\uff0c\u5c06\u4ecepg\u67e5\u8be2 " + this.wrapKey(id));
            T beanFromPg = this.getFromPg(id);
            if (beanFromPg != null) {
                this.insert2Redis(beanFromPg);
            }
            return beanFromPg;
        }
        catch (Exception ex) {
            this.logger.error("\u4ecepg\u4e1a\u52a1\u5e93\u52a0\u8f7d " + this.wrapKey(id) + " \u5931\u8d25", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void insert(T t) throws Exception {
        this.pgDao.insertOne(t);
        this.insert2Redis(t);
        this.redis.publish(this.category, RedisEvent.INSERT.toJsonBean((String)((Idable)t).getId()));
    }

    protected void insert2Redis(T t) throws Exception {
        this.sync2Redis(t);
    }

    private T getFromRedis(String id) throws Exception {
        try {
            IJsonable bean = null;
            try {
                String json = (String)this.redis.get(this.wrapKey(id));
                if (null != json) {
                    bean = (IJsonable)this.beanBuilder.fromJson(json);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return (T)bean;
        }
        catch (Exception e) {
            this.logger.info("redis\u4e2d\u672a\u67e5\u8be2\u5230\u5143\u6570\u636e\uff1a" + this.category + ":" + id);
            throw new NotFoundException(id);
        }
    }

    private T getFromPg(String id) throws Exception {
        try {
            return this.pgDao.findOne(id);
        }
        catch (Exception e) {
            this.logger.error("\u672a\u67e5\u8be2\u5230\u5143\u6570\u636e\uff1a" + this.category + "/" + id);
            if (id.startsWith("temp_")) {
                this.delete(id);
            }
            throw new Json2BeanFailedException(e);
        }
    }

    public boolean existsInBusiDB(String id) {
        try {
            return this.pgDao.exists(id);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u4e1a\u52a1\u5e93\u4e2d\u7684\u5143\u6570\u636e\u51fa\u9519\uff1a" + this.category + "/" + id, (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean exists(String id) throws Exception {
        boolean isExists = false;
        isExists = this.redis.exists(this.wrapKey(id));
        boolean existsInBusiDB = this.existsInBusiDB(id);
        if (isExists && !existsInBusiDB) {
            this.removeFromRedis(id);
            isExists = false;
        }
        isExists = existsInBusiDB;
        return isExists;
    }

    protected String path(String id) {
        return this.category + "/" + id;
    }

    private void isReady() throws Exception {
        if (!this.isReady.booleanValue()) {
            throw new Exception("\u5143\u6570\u636e\u8bbf\u95ee\u5ba2\u6237\u7aef\u6ca1\u6709\u51c6\u5907\u597d");
        }
    }

    @Override
    public void delete(String id) throws Exception {
        this.pgDao.deleteOne(id);
        this.removeFromRedis(id);
    }

    private void removeFromRedis(String id) throws Exception {
        this.redis.remove(this.wrapKey(id));
        this.redis.publish(this.category, RedisEvent.DELETE.toJsonBean(id));
    }

    @Override
    public void update(T t) throws Exception {
        String id = (String)((Idable)t).getId();
        this.pgDao.updateOne(id, t);
        this.update2Redis(t, id);
    }

    protected void update2Redis(T t, String id) throws Exception {
        this.sync2Redis(t);
        this.redis.publish(this.category, RedisEvent.UPDATE.toJsonBean(id));
    }

    @Override
    public List<T> query(QueryFilter queryFilter) {
        ArrayList<IJsonable> result = new ArrayList<IJsonable>();
        IInmemoryFilter<Object> filter = this.createObjectFilter(queryFilter);
        int start = queryFilter.getStart();
        int limit = queryFilter.getEnd();
        Map<String, T> allMeta = this.findAllMeta();
        Iterator<T> metaIterator = allMeta.values().iterator();
        if (start == -1 && limit == -1) {
            while (metaIterator.hasNext()) {
                IJsonable curMeta = (IJsonable)metaIterator.next();
                try {
                    if (!filter.isSave((Object)curMeta).booleanValue()) continue;
                    result.add(curMeta);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            int current = 0;
            while (metaIterator.hasNext()) {
                if (++current <= start) continue;
                IJsonable curMeta = (IJsonable)metaIterator.next();
                try {
                    if (filter.isSave((Object)curMeta).booleanValue()) {
                        result.add(curMeta);
                    }
                    if (result.size() != limit) continue;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private IInmemoryFilter<Object> createObjectFilter(QueryFilter queryFilter) {
        try {
            QueryFilterToInMemory queryFilterToInMemory = new QueryFilterToInMemory(queryFilter);
            IInmemoryFilter filter = queryFilterToInMemory.toInmemoryFilter();
            return filter;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataAccessException("\u67e5\u8be2\u89e3\u6790\u5668:" + queryFilter.toString() + "\u89e3\u6790\u51fa\u9519" + e.getMessage());
        }
    }

    private Map<String, T> findAllMeta() {
        List<String> scan = this.redis.scan(this.category + ":");
        HashMap<String, IJsonable> map = new HashMap<String, IJsonable>();
        for (String metaKey : scan) {
            String vectorMeta = this.redis.get(metaKey).toString();
            IJsonable metaValue = null;
            try {
                metaValue = (IJsonable)this.beanBuilder.fromJson(vectorMeta);
            }
            catch (Exception e) {
                this.logger.error("\u5143\u6570\u636e " + metaKey + " \u89e3\u6790\u5931\u8d25:" + e.getMessage() + e);
                continue;
            }
            map.put(metaKey, metaValue);
        }
        return map;
    }
}

