/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.atlas.license.authorize.LicenseCheck;
import com.geoway.vtile.commons.conf.CacheConfig;
import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.diagnose.ProfilingUtil;
import com.geoway.vtile.resources.datasource.db.DBPoolParameter;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.service.httpstatistic.AccessLogMonitor;
import com.geoway.vtile.service.netty.websocket.WebSocketServer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaServer {
    private static Logger LOG = LoggerFactory.getLogger(MetaServer.class);
    private static AppConfig _config;
    private static Client _client;

    public static void main(String[] args) {
        try {
            MetaServer.setUp(args);
            MetaServer.launchWSService();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void setUp(String[] args) throws Exception {
        System.out.println("=== parsing config ===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        CacheConfig.ENABLE_META_HTABLE_CACHE = true;
        AppConfig conf = new AppConfig();
        conf.loadConfig(args);
        _config = conf;
        _client = Client.create(conf.pgBuziDB, conf.redisUrl, conf.mapserverUrl);
        System.out.println("=== config completed ===");
    }

    public Boolean checkIsValid() {
        return LicenseCheck.isValid((int)64809);
    }

    public void setRTTThreadPoolSize(int threadCount) {
        if (threadCount > 0) {
            GlobalTileSettings.REALTIME_TILE_THREAD_COUNT = threadCount;
        }
    }

    public void setRTTDBPoolSize(int size) {
        if (size > 0) {
            DBPoolParameter.DEFAULT.setMaxActive(size);
        }
    }

    public void setCutFetchPageSize(int pgFetchSize) {
        if (pgFetchSize > 0) {
            GlobalTileSettings.PG_FETCH_PAGESIZE = pgFetchSize;
        }
    }

    public void setMongoPoolConfig(String mgpoolCfgJson) {
        try {
            if (StringUtils.isBlank((CharSequence)mgpoolCfgJson)) {
                return;
            }
            JSONObject jobj = JSON.parseObject((String)mgpoolCfgJson);
            Integer min = jobj.getInteger("minPoolSize");
            Integer max = jobj.getInteger("maxPoolSize");
            Integer maxIdle = jobj.getInteger("maxIdleTimeMS");
            if (null != min && min >= 0) {
                GlobalTileSettings.MGPOOL_MIN = min;
            }
            if (null != max && max > 0) {
                GlobalTileSettings.MGPOOL_MAX = max;
            }
            if (null != maxIdle && maxIdle > 0) {
                GlobalTileSettings.MGPOOL_IDLE_TIMEOUT_MS = maxIdle;
            }
            System.out.println("\u5df2\u8bbe\u7f6emongo\u8fde\u63a5\u6c60\u53c2\u6570\uff1a" + mgpoolCfgJson);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void enableProfiling(boolean onoff) {
        ProfilingUtil.enableProfiling((boolean)onoff);
    }

    public void setFrozenTimeout(int timeoutMs) {
        if (timeoutMs > 0) {
            GlobalTileSettings.RTT_FROZEN_TIMEOUT_MS = timeoutMs;
        }
    }

    public void startHttpLogMonitor(String accessLogPath, String options) {
        AccessLogMonitor.setLogMonitorOn(accessLogPath, options);
    }

    private static void launchWSService() throws Exception {
        int wsTcpPort = MetaServer._config.wsPort;
        LOG.info("\u51c6\u5907\u5f00\u542fWebSocket\u670d\u52a1\uff0c\u7aef\u53e3\uff1a" + wsTcpPort);
        new WebSocketServer(_client).bind(wsTcpPort);
    }

    public static class AppConfig {
        public String buziPgUrl = "";
        public String buziPgUser = "";
        public String buziPgPwd = "";
        public String basecfgFile = "";
        public String pgBuziDB = "jdbc:postgresql://atlas_cicd:gOxCb*&IGuF7@whpg12.geoway.net:5432/atlas_server_ywk_cicd?useUnicode=true&characterEncoding=utf8";
        public String redisUrl = "redis://127.0.0.1:6379";
        public String mapserverUrl = "http://172.16.83.221:8091/mapserver";
        public int wsPort = 3000;

        public void loadConfig(String[] args) {
            int n = args.length;
            block7: for (int i = 0; i < n; ++i) {
                LOG.info("\u53c2\u6570" + i + ": " + args[i]);
                switch (i + 1) {
                    case 1: {
                        this.basecfgFile = args[i];
                        continue block7;
                    }
                    case 2: {
                        this.pgBuziDB = args[i];
                        continue block7;
                    }
                    case 3: {
                        this.redisUrl = args[i];
                        continue block7;
                    }
                    case 4: {
                        this.mapserverUrl = args[i];
                        continue block7;
                    }
                    case 5: {
                        this.wsPort = Integer.parseInt(args[i]);
                    }
                }
            }
            System.out.println("=================");
        }
    }
}

