/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.manager;

import com.geoway.vtile.exception.ManagerDuplicateException;
import com.geoway.vtile.manager.IClientManager;
import com.geoway.vtile.service.client.Client;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerFactory {
    static Logger logger = LoggerFactory.getLogger(ManagerFactory.class);
    static ClassLoader loader;

    public static <T extends IClientManager> T getManager(Class<T> type, Client client) throws Exception {
        if (loader != null) {
            Thread.currentThread().setContextClassLoader(loader);
        }
        ServiceLoader<T> loader = ServiceLoader.load(type);
        Iterator<T> iterator = loader.iterator();
        IClientManager manager = null;
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            manager = (IClientManager)iterator.next();
        }
        if (count > 1) {
            throw new ManagerDuplicateException(type.getName() + "\u6709\u591a\u4e2a\u5b9e\u73b0\u7c7b");
        }
        if (manager != null) {
            manager.setClient(client);
            try {
                manager.init();
            }
            catch (Exception e) {
                logger.error(type.getName() + "\u521d\u59cb\u5316\u5931\u8d25");
                throw e;
            }
        }
        return (T)manager;
    }

    public static void setLoader(ClassLoader loader) {
        ManagerFactory.loader = loader;
    }
}

