/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.manager.abstractclass;

import com.geoway.vtile.bean.IJsonable;
import com.geoway.vtile.bean.IJsonableBuilder;
import com.geoway.vtile.bean.Idable;
import com.geoway.vtile.commons.conf.CacheConfig;
import com.geoway.vtile.commons.event.EventContainer;
import com.geoway.vtile.commons.event.IListener;
import com.geoway.vtile.dao.IMetaDataDao;
import com.geoway.vtile.exception.ExistsIdException;
import com.geoway.vtile.exception.NotFoundException;
import com.geoway.vtile.exception.ServerException;
import com.geoway.vtile.exception.UException;
import com.geoway.vtile.manager.IMetaDataManager;
import com.geoway.vtile.manager.abstractclass.DocumentableBuilder;
import com.geoway.vtile.manager.abstractclass.IEventMessage;
import com.geoway.vtile.model.IBeanBuilder;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datatable.dao.IScroll;
import com.geoway.vtile.resources.datatable.dao.IteratorScroll;
import com.geoway.vtile.resources.exception.IdFieldValueEmptyException;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.structure.queryhashtable.QueryHashTableHeap;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManager<T extends IJsonable & Idable<String>, Builder extends IJsonableBuilder<T> & DocumentableBuilder<T>>
implements IMetaDataManager<T> {
    Logger logger = LoggerFactory.getLogger(AbstractManager.class);
    protected QueryHashTableHeap<String, T> table;
    protected String idFieldName = "id";
    protected Client client;
    protected Boolean readOnly = false;
    protected String managerRoot;
    protected static final String INFO_FIELD = "data";
    protected Builder beanBuilder;
    protected Boolean isReady = false;
    protected EventContainer<IListener> eventContainer = new EventContainer();
    protected IMetaDataDao<T> metaDataDao;
    protected Boolean useTableCache = false;

    public AbstractManager(Builder beanBuilder, String managerRoot) {
        this.managerRoot = managerRoot;
        this.beanBuilder = beanBuilder;
        this.useTableCache = CacheConfig.ENABLE_META_HTABLE_CACHE;
    }

    @Override
    public void init() throws Exception {
        ((IBeanBuilder)this.beanBuilder).setClient(this.client);
        this.table = new QueryHashTableHeap(this.idFieldName);
        this.metaDataDao = this.getMetaDataDao();
        List<T> list = this.metaDataDao.findAll();
        if (null != list) {
            for (IJsonable t : list) {
                this.saveBeanToHashTable(t);
                this.metaDataDao.sync2Redis(t);
            }
        }
    }

    protected abstract IMetaDataDao<T> getMetaDataDao() throws Exception;

    protected void saveBeanToHashTable(T bean) {
        if (!this.useTableCache.booleanValue() || this.table == null) {
            return;
        }
        this.table.insert(bean);
    }

    protected void removeBeanToHashTable(String pk) {
        if (!this.useTableCache.booleanValue() || this.table == null) {
            return;
        }
        this.table.remove((Serializable)((Object)pk));
    }

    protected void updateBeanToHashTable(T bean) {
        if (!this.useTableCache.booleanValue() || this.table == null) {
            return;
        }
        this.table.update(bean);
    }

    public Boolean exists(String id) throws Exception {
        if (this.useTableCache.booleanValue() && this.table.get((Serializable)((Object)id)) != null) {
            return true;
        }
        return this.metaDataDao.exists(id);
    }

    protected void isReady() throws Exception {
    }

    protected void doAdd(T t) throws Exception {
        this.isReady();
        String id = (String)((Idable)t).getId();
        if (id == null) {
            throw new IdFieldValueEmptyException(this.idFieldName, t);
        }
        if (this.exists(id).booleanValue()) {
            throw new ExistsIdException(id);
        }
        this.saveBeanToHashTable(t);
        try {
            this.metaDataDao.insert(t);
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            this.removeBeanToHashTable(id);
            throw e;
        }
        this.eventContainer.syncFireEvent(IEventMessage.EVENT_TYPE.register.name(), new Object[]{id, t});
    }

    protected void doUpdate(T t) throws Exception {
        this.isReady();
        String id = (String)((Idable)t).getId();
        if (id == null) {
            throw new IdFieldValueEmptyException(this.idFieldName, t);
        }
        if (!this.exists(id).booleanValue()) {
            throw new NotFoundException(id);
        }
        this.updateBeanToHashTable(t);
        try {
            this.metaDataDao.update(t);
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            throw e;
        }
        this.eventContainer.syncFireEvent(IEventMessage.EVENT_TYPE.update.name(), new Object[]{id, t});
    }

    protected void doRemove(String id) throws Exception {
        this.isReady();
        if (!this.exists(id).booleanValue()) {
            throw new NotFoundException(id);
        }
        this.removeBeanToHashTable(id);
        try {
            this.metaDataDao.delete(id);
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            throw e;
        }
        this.eventContainer.syncFireEvent(IEventMessage.EVENT_TYPE.unRegister.name(), new Object[]{id, null});
    }

    public void on(IEventMessage.EVENT_TYPE type, IEventMessage<T> e) {
        this.eventContainer.addListener(type.name(), parameter -> {
            IJsonable t = parameter[1] == null ? null : (IJsonable)parameter[1];
            e.fire((String)parameter[0], t);
        });
    }

    @Override
    public List<T> list(QueryFilter queryFilter) {
        if (null == queryFilter || 0 == queryFilter.getCommands().size()) {
            return this.findAll();
        }
        if (this.useTableCache.booleanValue() && this.table != null) {
            return this.table.query(queryFilter);
        }
        return this.metaDataDao.query(queryFilter);
    }

    @Override
    public List<T> findAll() {
        if (this.useTableCache.booleanValue() && null != this.table) {
            return this.table.query(new QueryFilter());
        }
        try {
            return this.metaDataDao.findAll();
        }
        catch (Exception e) {
            throw new ServerException(this.managerRoot + " \u6570\u636e\u67e5\u8be2\u5931\u8d25");
        }
    }

    @Override
    public T findOne(QueryFilter queryFilter) {
        if (this.useTableCache.booleanValue() && null != this.table) {
            IScroll scroll = this.table.scroll(queryFilter);
            if (scroll.hasNext()) {
                return (T)((IJsonable)scroll.next());
            }
        } else {
            List<T> query = this.metaDataDao.query(queryFilter);
            if (null != query && query.size() > 0) {
                return (T)((IJsonable)query.get(0));
            }
        }
        return null;
    }

    @Override
    public IScroll<T> scroll(QueryFilter queryFilter) {
        if (this.useTableCache.booleanValue() && null != this.table) {
            return this.table.scroll(queryFilter);
        }
        if (null == queryFilter || 0 == queryFilter.getCommands().size()) {
            try {
                List<T> items = this.metaDataDao.findAll();
                return new IteratorScroll(items);
            }
            catch (Exception e) {
                throw new ServerException(this.managerRoot + " \u6570\u636e\u904d\u5386\u5931\u8d25");
            }
        }
        List<T> items = this.metaDataDao.query(queryFilter);
        return new IteratorScroll(items);
    }

    @Override
    public T get(String id) {
        IJsonable t = null;
        if (this.useTableCache.booleanValue() && this.table != null) {
            t = (IJsonable)this.table.get((Serializable)((Object)id));
        }
        if (t == null) {
            try {
                t = (IJsonable)this.metaDataDao.findOne(id);
            }
            catch (Exception e) {
                throw new ServerException(this.managerRoot + ": id\u4e3a " + id + "\u7684\u6570\u636e\u62c9\u53d6\u5931\u8d25");
            }
            if (t != null) {
                try {
                    this.saveBeanToHashTable(t);
                }
                catch (Exception e) {
                    this.logger.warn("\u7f13\u5b58\u4e2d\u5df2\u7ecf\u5b58\u5728id\u4e3a\uff1a" + this.managerRoot + ":" + id + "\u7684\u6570\u636e\uff0c\u5ffd\u7565\u672c\u6b21\u63d2\u5165");
                }
            }
        }
        return (T)t;
    }

    @Override
    public String getJSON(String id) {
        try {
            T bean = this.get(id);
            if (bean != null) {
                return bean.toJson();
            }
            return null;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            return null;
        }
    }

    @Override
    public void setClient(Client client) {
        this.client = client;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

