/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.manager.abstractclass;

import com.geoway.vtile.bean.IJsonable;
import com.geoway.vtile.bean.IJsonableBuilder;
import com.geoway.vtile.bean.Idable;
import com.geoway.vtile.exception.NotFoundException;
import com.geoway.vtile.exception.UException;
import com.geoway.vtile.manager.abstractclass.AbstractManager;
import com.geoway.vtile.manager.abstractclass.DocumentableBuilder;
import com.geoway.vtile.manager.abstractclass.IEventMessage;
import com.geoway.vtile.model.ICanStartStop;

public abstract class ServiceManager<T extends IJsonable & Idable<String> & ICanStartStop, Builder extends IJsonableBuilder<T> & DocumentableBuilder<T>>
extends AbstractManager<T, Builder> {
    public ServiceManager(Builder beanBuilder, String managerRoot) {
        super(beanBuilder, managerRoot);
    }

    protected T startBean2Table(String id) {
        Object t = this.get(id);
        if (t == null) {
            throw new NotFoundException(id);
        }
        ((ICanStartStop)t).start();
        return t;
    }

    protected T stopBean2Table(String id) {
        Object t = this.get(id);
        if (t == null) {
            throw new NotFoundException(id);
        }
        ((ICanStartStop)t).stop();
        return t;
    }

    protected void rollback2Table(String id, ICanStartStop.STATE_TYPE state) throws NotFoundException {
        Object t = this.get(id);
        if (t == null) {
            throw new NotFoundException(id);
        }
        ((ICanStartStop)t).rollback(state);
    }

    public void start(String id) throws Exception {
        T t = this.startBean2Table(id);
        try {
            this.doUpdate(t);
            this.eventContainer.syncFireEvent(IEventMessage.EVENT_TYPE.start.name(), new Object[]{id, t});
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            this.rollback2Table(id, ICanStartStop.STATE_TYPE.stop);
            throw e;
        }
    }

    public void stop(String id) throws Exception {
        T t = this.stopBean2Table(id);
        try {
            this.doUpdate(t);
            this.eventContainer.syncFireEvent(IEventMessage.EVENT_TYPE.stop.name(), new Object[]{id, t});
        }
        catch (Exception e) {
            e.printStackTrace();
            this.rollback2Table(id, ICanStartStop.STATE_TYPE.run);
            throw e;
        }
    }
}

