/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.manager.font;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.geoway.vtile.dao.IMetaDataDao;
import com.geoway.vtile.dao.font.FontDao;
import com.geoway.vtile.dao.font.FontPgDao;
import com.geoway.vtile.exception.NotSupport;
import com.geoway.vtile.manager.abstractclass.AbstractManager;
import com.geoway.vtile.manager.font.IFontManager;
import com.geoway.vtile.model.Constants;
import com.geoway.vtile.model.font.FontBean;
import com.geoway.vtile.model.font.FontBuilder;
import com.geoway.vtile.model.font.FontShell;
import com.geoway.vtile.model.font.IFontService;
import com.geoway.vtile.resources.command.Constants;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.structure.queryhashtable.QueryHashTableHeap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.util.Assert;

public class FontManager
extends AbstractManager<IFontService, FontBuilder>
implements IFontManager {
    protected static final String MANAGER_ROOT = "font";
    private FontPgDao pgDao;

    public FontManager() {
        super(FontBuilder.getInstance(), MANAGER_ROOT);
        this.idFieldName = "filename";
        this.useTableCache = true;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.metaDataDao instanceof FontDao) {
            this.pgDao = (FontPgDao)((FontDao)this.metaDataDao).getPgDao();
        }
    }

    @Override
    protected IMetaDataDao<IFontService> getMetaDataDao() throws Exception {
        if (this.metaDataDao == null) {
            FontDao metaDao = new FontDao(this.idFieldName, (FontBuilder)this.beanBuilder, (QueryHashTableHeap<String, IFontService>)this.table, this.client, this.managerRoot, this.readOnly, this);
            metaDao.init();
            this.metaDataDao = metaDao;
        }
        return this.metaDataDao;
    }

    @Override
    public void register(IFontService font) throws Exception {
        if (this.get((String)font.getId()) == null) {
            super.doAdd(font);
        } else {
            super.doUpdate(font);
        }
    }

    @Override
    public void unRegister(String id) throws Exception {
        super.doRemove(id);
    }

    @Override
    public void unRegister(String family, Constants.FONT_STYLE style, Constants.FONT_WEIGHT weight, Constants.FONT_FILE_TYPE fileType) throws Exception {
        String id = this.generateFontId(family, style, weight, fileType);
        super.doRemove(id);
    }

    @Override
    public void unRegisterByFamily(String family) throws Exception {
        if (StringUtils.isEmpty((CharSequence)family)) {
            return;
        }
        QueryFilter filter = new QueryFilter();
        filter.addFilter("family", Constants.OPERATION.EQ, new Object[]{family});
        List<IFontService> list = this.list(filter);
        for (IFontService iFontService : list) {
            this.unRegister((String)iFontService.getId());
        }
    }

    @Override
    public List<IFontService> list(QueryFilter filter) {
        List<IFontService> list = super.list(filter);
        if (list == null) {
            list = new ArrayList(0);
        }
        Map<String, List<IFontService>> map = list.stream().collect(Collectors.groupingBy(font -> font.getFamily() + "_" + (Object)((Object)font.getStyle()) + "_" + (Object)((Object)font.getWeight())));
        for (String key : map.keySet()) {
            List<IFontService> flist = map.get(key);
            boolean hasNN = flist.stream().anyMatch(font -> font.getStyle() == Constants.FONT_STYLE.normal && font.getWeight() == Constants.FONT_WEIGHT.normal);
            if (hasNN) continue;
            list.removeAll(flist);
        }
        return list;
    }

    @Override
    public String map(String idPatternStr, Integer start, Integer limit) {
        QueryFilter filter = new QueryFilter();
        if (StringUtils.isNotEmpty((CharSequence)idPatternStr)) {
            String[] idPatterns = idPatternStr.split(",");
            for (int i = 0; i < idPatterns.length; ++i) {
                String idPattern = idPatterns[i];
                if (i == 0) {
                    filter.addFilter("id", Constants.OPERATION.LFK, new Object[]{idPattern});
                    continue;
                }
                filter.addFilter(Constants.RELATION.OR, "id", Constants.OPERATION.LFK, new Object[]{idPattern});
            }
        }
        List<IFontService> list = this.list(filter);
        Map<String, List<IFontService>> map = list.stream().collect(Collectors.groupingBy(IFontService::getFamily));
        Iterator<String> iterator = map.keySet().iterator();
        JSONObject obj = new JSONObject();
        while (iterator.hasNext()) {
            String family = iterator.next();
            List<IFontService> familyList = map.get(family);
            Map<String, Map<String, Object>> familymap = familyList.stream().collect(Collectors.groupingBy(font -> (Object)((Object)font.getStyle()) + "_" + (Object)((Object)font.getWeight()), Collectors.toMap(font -> font.getFileType().toString(), font -> font)));
            obj.put(family, familymap);
        }
        return obj.toJSONString();
    }

    @Override
    public String fontsMap(String idsFilter) {
        List<IFontService> list;
        QueryFilter filter = new QueryFilter();
        if (StringUtils.isNotEmpty((CharSequence)idsFilter)) {
            filter.addFilter("id", Constants.OPERATION.IN, new Object[]{idsFilter});
        }
        if ((list = super.list(filter)) == null) {
            return "{}";
        }
        HashMap map = new HashMap();
        list.forEach(f -> map.put(f.getId(), f));
        SimplePropertyPreFilter fieldFilter = new SimplePropertyPreFilter(new String[0]);
        fieldFilter.getExcludes().add("bean");
        return JSON.toJSONString(map, (SerializeFilter)fieldFilter, (SerializerFeature[])new SerializerFeature[0]);
    }

    @Override
    public IFontService get(String family, Constants.FONT_STYLE style, Constants.FONT_WEIGHT weight, Constants.FONT_FILE_TYPE fileType) {
        String id = this.generateFontId(family, style, weight, fileType);
        return (IFontService)super.get(id);
    }

    @Override
    public boolean checkVersion(String family, Constants.FONT_STYLE style, Constants.FONT_WEIGHT weight, String version, Constants.FONT_FILE_TYPE fileType) {
        IFontService font = this.get(family, style, weight, fileType);
        return Objects.equals(version, font.getVersion());
    }

    @Override
    public boolean checkVersion(String id, String version) {
        IFontService font = (IFontService)this.get(id);
        return Objects.equals(version, font.getVersion());
    }

    @Override
    public byte[] getContent(String id) {
        try {
            IFontService font = this.pgDao.findOne(id);
            Assert.isTrue((font != null ? 1 : 0) != 0, (String)("\u5b57\u4f53\u4e0d\u5b58\u5728 : " + id));
            return font.getContent();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDefaultFont() throws Exception {
        List<IFontService> list = this.list(new QueryFilter());
        Optional<IFontService> optional = list.stream().filter(font -> font.isDefaultFont()).findFirst();
        if (optional.isPresent()) {
            return optional.get().getFamily();
        }
        return null;
    }

    @Override
    public String getForeendUnCommon() throws Exception {
        List<IFontService> list = this.list(new QueryFilter());
        Optional<IFontService> optional = list.stream().filter(font -> font.isForeendUnCommon()).findFirst();
        if (optional.isPresent()) {
            return optional.get().getFamily();
        }
        return null;
    }

    @Override
    public String getBackendUnCommon() throws Exception {
        List<IFontService> list = this.list(new QueryFilter());
        Optional<IFontService> optional = list.stream().filter(font -> font.isBackendUnCommon()).findFirst();
        if (optional.isPresent()) {
            return optional.get().getFamily();
        }
        return null;
    }

    @Override
    public String getFontConfig() throws Exception {
        List<IFontService> list = this.list(new QueryFilter());
        Optional<IFontService> optional = list.stream().filter(font -> font.isForeendUnCommon()).findFirst();
        String foreendUnCommon = "";
        if (optional.isPresent()) {
            foreendUnCommon = optional.get().getFamily();
        }
        Set families = list.stream().map(font -> font.getFamily()).collect(Collectors.toSet());
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("foreendUnCommonFont", foreendUnCommon);
        result.put("fonts", families);
        return JSON.toJSONString(result);
    }

    private String generateFontId(String family, Constants.FONT_STYLE style, Constants.FONT_WEIGHT weight, Constants.FONT_FILE_TYPE fileType) {
        return family + "." + (Object)((Object)fileType);
    }

    @Override
    public void update(IFontService t) throws Exception {
        throw new NotSupport();
    }

    @Override
    public void start(String id) throws Exception {
        throw new NotSupport();
    }

    @Override
    public void stop(String id) throws Exception {
        throw new NotSupport();
    }

    @Override
    public IFontService findOne(QueryFilter queryFilter) {
        throw new NotSupport();
    }

    @Override
    public void rename(String id, String newName) throws Exception {
        throw new NotSupport();
    }

    @Override
    protected void saveBeanToHashTable(IFontService fontService) {
        FontBean clone = null;
        try {
            clone = ((FontBean)fontService.getBean()).clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.setContent(null);
        super.saveBeanToHashTable(new FontShell(clone));
    }
}

