/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.model.data_source;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.vtile.bean.IJsonableBuilder;
import com.geoway.vtile.manager.abstractclass.DocumentableBuilder;
import com.geoway.vtile.model.IBeanBuilder;
import com.geoway.vtile.model.data_source.DataScourceShell;
import com.geoway.vtile.model.data_source.IDataSourceInService;
import com.geoway.vtile.resources.datasource.IDataSource;
import com.geoway.vtile.service.client.Client;
import org.bson.Document;

public class DataSourceBuilder
implements IJsonableBuilder<IDataSourceInService>,
DocumentableBuilder<IDataSourceInService>,
IBeanBuilder {
    private Client client;
    private static DataSourceBuilder _DATA_SOURCE_BUILDER = new DataSourceBuilder();
    public static final String DATA_SOURCE_TYPE_FILED = "dataSourceType";

    public static DataSourceBuilder getInstance() {
        return _DATA_SOURCE_BUILDER;
    }

    public DataSourceBuilder() {
    }

    public DataSourceBuilder(Client client) {
        this.client = client;
    }

    public IDataSourceInService fromJson(String json) throws Exception {
        JSONObject object = JSON.parseObject((String)json);
        String name = object.getString("name");
        String shellid = object.getString("shellid");
        IDataSource dataSource = IDataSource.fromJSON((String)json);
        if (dataSource.getId() == null) {
            return null;
        }
        return new DataScourceShell(this.client, name, shellid, dataSource);
    }

    @Override
    public IDataSourceInService fromDocument(Document str) throws Exception {
        str.remove((Object)"_id");
        return this.fromJson(str.toJson());
    }

    @Override
    public void setClient(Client client) {
        this.client = client;
    }
}

