/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.model.texture;

import com.geoway.vtile.model.texture.ITextureService;
import com.geoway.vtile.model.texture.TextureBean;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import org.bson.Document;

public class TextureShell
implements ITextureService {
    TextureBean texture;

    public TextureShell(TextureBean texture) {
        this.texture = texture;
    }

    public String getId() {
        return this.texture.getId();
    }

    public String toJson() {
        return this.texture.toJson();
    }

    public TextureBean getTexture() {
        return this.texture;
    }

    public void setTexture(TextureBean texture) {
        this.texture = texture;
    }

    @Override
    public boolean isValid() {
        switch (this.texture.getType()) {
            case png: {
                break;
            }
            case svg: {
                String[] str = this.texture.getContent().split(",");
                try {
                    byte[] decodeContent = Base64.getDecoder().decode(str[1].getBytes("GBK"));
                    String keyStr = new String(new String(decodeContent, "GBK"));
                    if (keyStr.indexOf("<image") != -1) {
                        return false;
                    }
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return this.texture.getName();
    }

    @Override
    public TextureBean getBean() {
        return this.texture;
    }

    public String toString() {
        return this.toJson();
    }

    @Override
    public Document toDocument() {
        return this.texture.toDocument();
    }
}

