/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.model.vector_service;

import com.geoway.vtile.bean.IJsonable;
import com.geoway.vtile.bean.IMarkable;
import com.geoway.vtile.bean.Idable;
import com.geoway.vtile.model.IBeanShell;
import com.geoway.vtile.model.ICanStartStop;
import com.geoway.vtile.model.IDocumentAble;
import com.geoway.vtile.model.IService;
import com.geoway.vtile.model.IVersionAble;
import com.geoway.vtile.model.data_service.FieldsConfig;
import com.geoway.vtile.model.vector_service.ICacheable;
import com.geoway.vtile.model.vector_service.VectorServiceBean;
import com.geoway.vtile.model.vector_service.VectorServiceShell;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.LayerDataBean;
import com.geoway.vtile.model.vector_service.storage.IStorageInfo;
import com.geoway.vtile.model.vector_service.utfgrid.IUtfgridInfo;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.spatial.grid.IGridSystem;
import java.util.List;
import java.util.Map;

public interface IVectorService
extends IService,
IJsonable,
IMarkable,
Idable<String>,
IDocumentAble,
ICanStartStop,
ICacheable,
IVersionAble,
IBeanShell<VectorServiceBean> {
    public void addUtfgridInfo(IUtfgridInfo var1);

    public void addCacheInfo(ICacheable var1);

    public String getName();

    public IGridSystem getGridTree();

    public String getBbox();

    public Integer getBeginLevel();

    public Integer getEndLevel();

    public Map<String, ILayer> getLayerMap();

    public Boolean isSinglelayer();

    public Boolean allowCache();

    public Client getClient();

    public void refresh();

    public static IVectorService create(Client client, VectorServiceBean vectorService) {
        return new VectorServiceShell(client, vectorService);
    }

    public void addStorageInfo(IStorageInfo var1);

    public void addStorageInfo(IStorageInfo var1, Map<String, LayerDataBean> var2);

    public ICacheable getCacheInfo();

    public IStorageInfo getStorageInfo();

    public IUtfgridInfo getUtfgridInfo();

    public List<FieldsConfig> getLayerFields(ILayer var1);

    public String getLayerIdFieldName(ILayer var1);

    public String getLayerIdFieldType(ILayer var1);

    public String getLayerGeometryType(ILayer var1);

    public int[] getOrigin();

    public double[] getResolutions();

    public List<String> getDataServiceIds();

    public Map<String, LayerDataBean> getCacheTileLayers();

    public Boolean isExpand();
}

