/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.model.vector_service.storage;

import com.geoway.vtile.model.data_source.IDataSourceInService;
import com.geoway.vtile.model.vector_service.storage.IStorageInfo;
import com.geoway.vtile.model.vector_service.storage.StorageInfoBean;
import com.geoway.vtile.resources.MongodbFactory;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.service.client.Client;
import com.mongodb.client.model.CreateCollectionOptions;
import org.apache.commons.lang3.StringUtils;

public class StorageInfoShell
implements IStorageInfo {
    protected StorageInfoBean bean;
    protected Client client;

    public StorageInfoShell(Client client, StorageInfoBean storageBean) {
        this.client = client;
        this.bean = storageBean;
    }

    @Override
    public IDataSourceInService getDataSource() {
        IDataSourceInService dataSourceInService = (IDataSourceInService)this.client.getDataSourcesManager().get(this.bean.getDataSourceId());
        if (dataSourceInService == null) {
            throw new RuntimeException(String.format("\u6570\u636e\u6e90%s\u4e0d\u5b58\u5728", this.bean.getDataSourceId()));
        }
        return dataSourceInService;
    }

    @Override
    public StorageInfoBean getBean() {
        return this.bean;
    }

    @Override
    public Integer getStartLevel() {
        return this.bean.getStartLevel();
    }

    @Override
    public Integer getEndLevel() {
        return this.bean.getEndLevel();
    }

    @Override
    public String getStorageName() {
        return this.bean.getStorageName();
    }

    @Override
    public String getLabelStorageName() {
        return this.bean.getLabelStorageName();
    }

    @Override
    public Boolean isCompleted() {
        return this.bean.isCompleted();
    }

    @Override
    public void setCompleted(boolean completed) {
        this.bean.setCompleted(completed);
    }

    @Override
    public void drop() {
        IDataSourceInService dataSourceInService = (IDataSourceInService)this.client.getDataSourcesManager().get(this.bean.getDataSourceId());
        if (dataSourceInService != null) {
            MongodbFactory factory = ((MongodbDataSource)dataSourceInService.getBean()).factory();
            factory.dropCollection(this.getStorageName());
            if (this.getLabelStorageName() != null) {
                factory.dropCollection(this.getLabelStorageName());
            }
        }
    }

    @Override
    public void rename(String newName) {
        IDataSourceInService dataSourceInService = (IDataSourceInService)this.client.getDataSourcesManager().get(this.bean.getDataSourceId());
        if (dataSourceInService != null) {
            MongodbFactory factory = ((MongodbDataSource)dataSourceInService.getBean()).factory();
            String storageName = this.getStorageName();
            String newStorageName = StringUtils.join((Object[])new String[]{"storage_", newName, "_layer"});
            if (factory.collectionExist(storageName).booleanValue()) {
                factory.renameCollection(storageName, newStorageName);
            } else {
                CreateCollectionOptions options = new CreateCollectionOptions();
                factory.createCollection(newStorageName, options);
            }
            this.bean.setStorageName(newStorageName);
        }
    }

    @Override
    public void renameLabel(String newName) {
        IDataSourceInService dataSourceInService = (IDataSourceInService)this.client.getDataSourcesManager().get(this.bean.getDataSourceId());
        if (dataSourceInService != null) {
            MongodbFactory factory = ((MongodbDataSource)dataSourceInService.getBean()).factory();
            String labelStorageName = this.getLabelStorageName();
            String newLayerStorageName = StringUtils.join((Object[])new String[]{"storage_", newName, "_label"});
            if (StringUtils.isNotBlank((CharSequence)labelStorageName)) {
                if (factory.collectionExist(labelStorageName).booleanValue()) {
                    factory.renameCollection(labelStorageName, newLayerStorageName);
                }
                this.bean.setLabelStorageName(newLayerStorageName);
            }
        }
    }
}

